/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.translate.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.translate.model.DisplayLanguageCode;
import com.amazonaws.services.translate.model.Language;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListLanguagesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Language> languages;
    private String displayLanguageCode;
    private String nextToken;

    public List<Language> getLanguages() {
        return this.languages;
    }

    public void setLanguages(Collection<Language> languages) {
        if (languages == null) {
            this.languages = null;
            return;
        }
        this.languages = new ArrayList<Language>(languages);
    }

    public ListLanguagesResult withLanguages(Language ... languages) {
        if (this.languages == null) {
            this.setLanguages(new ArrayList<Language>(languages.length));
        }
        for (Language ele : languages) {
            this.languages.add(ele);
        }
        return this;
    }

    public ListLanguagesResult withLanguages(Collection<Language> languages) {
        this.setLanguages(languages);
        return this;
    }

    public void setDisplayLanguageCode(String displayLanguageCode) {
        this.displayLanguageCode = displayLanguageCode;
    }

    public String getDisplayLanguageCode() {
        return this.displayLanguageCode;
    }

    public ListLanguagesResult withDisplayLanguageCode(String displayLanguageCode) {
        this.setDisplayLanguageCode(displayLanguageCode);
        return this;
    }

    public ListLanguagesResult withDisplayLanguageCode(DisplayLanguageCode displayLanguageCode) {
        this.displayLanguageCode = displayLanguageCode.toString();
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListLanguagesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLanguages() != null) {
            sb.append("Languages: ").append(this.getLanguages()).append(",");
        }
        if (this.getDisplayLanguageCode() != null) {
            sb.append("DisplayLanguageCode: ").append(this.getDisplayLanguageCode()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLanguagesResult)) {
            return false;
        }
        ListLanguagesResult other = (ListLanguagesResult)obj;
        if (other.getLanguages() == null ^ this.getLanguages() == null) {
            return false;
        }
        if (other.getLanguages() != null && !other.getLanguages().equals(this.getLanguages())) {
            return false;
        }
        if (other.getDisplayLanguageCode() == null ^ this.getDisplayLanguageCode() == null) {
            return false;
        }
        if (other.getDisplayLanguageCode() != null && !other.getDisplayLanguageCode().equals(this.getDisplayLanguageCode())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLanguages() == null ? 0 : this.getLanguages().hashCode());
        hashCode = 31 * hashCode + (this.getDisplayLanguageCode() == null ? 0 : this.getDisplayLanguageCode().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListLanguagesResult clone() {
        try {
            return (ListLanguagesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

