/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.translate.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.translate.model.TextTranslationJobProperties;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class TextTranslationJobPropertiesMarshaller {
    private static final MarshallingInfo<String> JOBID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobId").build();
    private static final MarshallingInfo<String> JOBNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobName").build();
    private static final MarshallingInfo<String> JOBSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobStatus").build();
    private static final MarshallingInfo<StructuredPojo> JOBDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobDetails").build();
    private static final MarshallingInfo<String> SOURCELANGUAGECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceLanguageCode").build();
    private static final MarshallingInfo<List> TARGETLANGUAGECODES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetLanguageCodes").build();
    private static final MarshallingInfo<List> TERMINOLOGYNAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TerminologyNames").build();
    private static final MarshallingInfo<List> PARALLELDATANAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParallelDataNames").build();
    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Message").build();
    private static final MarshallingInfo<Date> SUBMITTEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubmittedTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<StructuredPojo> INPUTDATACONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputDataConfig").build();
    private static final MarshallingInfo<StructuredPojo> OUTPUTDATACONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputDataConfig").build();
    private static final MarshallingInfo<String> DATAACCESSROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataAccessRoleArn").build();
    private static final TextTranslationJobPropertiesMarshaller instance = new TextTranslationJobPropertiesMarshaller();

    public static TextTranslationJobPropertiesMarshaller getInstance() {
        return instance;
    }

    public void marshall(TextTranslationJobProperties textTranslationJobProperties, ProtocolMarshaller protocolMarshaller) {
        if (textTranslationJobProperties == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)textTranslationJobProperties.getJobId(), JOBID_BINDING);
            protocolMarshaller.marshall((Object)textTranslationJobProperties.getJobName(), JOBNAME_BINDING);
            protocolMarshaller.marshall((Object)textTranslationJobProperties.getJobStatus(), JOBSTATUS_BINDING);
            protocolMarshaller.marshall((Object)textTranslationJobProperties.getJobDetails(), JOBDETAILS_BINDING);
            protocolMarshaller.marshall((Object)textTranslationJobProperties.getSourceLanguageCode(), SOURCELANGUAGECODE_BINDING);
            protocolMarshaller.marshall(textTranslationJobProperties.getTargetLanguageCodes(), TARGETLANGUAGECODES_BINDING);
            protocolMarshaller.marshall(textTranslationJobProperties.getTerminologyNames(), TERMINOLOGYNAMES_BINDING);
            protocolMarshaller.marshall(textTranslationJobProperties.getParallelDataNames(), PARALLELDATANAMES_BINDING);
            protocolMarshaller.marshall((Object)textTranslationJobProperties.getMessage(), MESSAGE_BINDING);
            protocolMarshaller.marshall((Object)textTranslationJobProperties.getSubmittedTime(), SUBMITTEDTIME_BINDING);
            protocolMarshaller.marshall((Object)textTranslationJobProperties.getEndTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall((Object)textTranslationJobProperties.getInputDataConfig(), INPUTDATACONFIG_BINDING);
            protocolMarshaller.marshall((Object)textTranslationJobProperties.getOutputDataConfig(), OUTPUTDATACONFIG_BINDING);
            protocolMarshaller.marshall((Object)textTranslationJobProperties.getDataAccessRoleArn(), DATAACCESSROLEARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

