/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transfer.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.transfer.model.FileLocation;

@SdkInternalApi
public class FileLocationMarshaller {
    private static final MarshallingInfo<StructuredPojo> S3FILELOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3FileLocation").build();
    private static final MarshallingInfo<StructuredPojo> EFSFILELOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EfsFileLocation").build();
    private static final FileLocationMarshaller instance = new FileLocationMarshaller();

    public static FileLocationMarshaller getInstance() {
        return instance;
    }

    public void marshall(FileLocation fileLocation, ProtocolMarshaller protocolMarshaller) {
        if (fileLocation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)fileLocation.getS3FileLocation(), S3FILELOCATION_BINDING);
            protocolMarshaller.marshall((Object)fileLocation.getEfsFileLocation(), EFSFILELOCATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

