/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transfer.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.transfer.model.ListedExecution;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListExecutionsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private String workflowId;
    private List<ListedExecution> executions;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListExecutionsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setWorkflowId(String workflowId) {
        this.workflowId = workflowId;
    }

    public String getWorkflowId() {
        return this.workflowId;
    }

    public ListExecutionsResult withWorkflowId(String workflowId) {
        this.setWorkflowId(workflowId);
        return this;
    }

    public List<ListedExecution> getExecutions() {
        return this.executions;
    }

    public void setExecutions(Collection<ListedExecution> executions) {
        if (executions == null) {
            this.executions = null;
            return;
        }
        this.executions = new ArrayList<ListedExecution>(executions);
    }

    public ListExecutionsResult withExecutions(ListedExecution ... executions) {
        if (this.executions == null) {
            this.setExecutions(new ArrayList<ListedExecution>(executions.length));
        }
        for (ListedExecution ele : executions) {
            this.executions.add(ele);
        }
        return this;
    }

    public ListExecutionsResult withExecutions(Collection<ListedExecution> executions) {
        this.setExecutions(executions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getWorkflowId() != null) {
            sb.append("WorkflowId: ").append(this.getWorkflowId()).append(",");
        }
        if (this.getExecutions() != null) {
            sb.append("Executions: ").append(this.getExecutions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExecutionsResult)) {
            return false;
        }
        ListExecutionsResult other = (ListExecutionsResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getWorkflowId() == null ^ this.getWorkflowId() == null) {
            return false;
        }
        if (other.getWorkflowId() != null && !other.getWorkflowId().equals(this.getWorkflowId())) {
            return false;
        }
        if (other.getExecutions() == null ^ this.getExecutions() == null) {
            return false;
        }
        return other.getExecutions() == null || other.getExecutions().equals(this.getExecutions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getWorkflowId() == null ? 0 : this.getWorkflowId().hashCode());
        hashCode = 31 * hashCode + (this.getExecutions() == null ? 0 : this.getExecutions().hashCode());
        return hashCode;
    }

    public ListExecutionsResult clone() {
        try {
            return (ListExecutionsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

