/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transcribe;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.transcribe.AmazonTranscribe;
import com.amazonaws.services.transcribe.AmazonTranscribeClientBuilder;
import com.amazonaws.services.transcribe.model.AmazonTranscribeException;
import com.amazonaws.services.transcribe.model.CreateLanguageModelRequest;
import com.amazonaws.services.transcribe.model.CreateLanguageModelResult;
import com.amazonaws.services.transcribe.model.CreateMedicalVocabularyRequest;
import com.amazonaws.services.transcribe.model.CreateMedicalVocabularyResult;
import com.amazonaws.services.transcribe.model.CreateVocabularyFilterRequest;
import com.amazonaws.services.transcribe.model.CreateVocabularyFilterResult;
import com.amazonaws.services.transcribe.model.CreateVocabularyRequest;
import com.amazonaws.services.transcribe.model.CreateVocabularyResult;
import com.amazonaws.services.transcribe.model.DeleteLanguageModelRequest;
import com.amazonaws.services.transcribe.model.DeleteLanguageModelResult;
import com.amazonaws.services.transcribe.model.DeleteMedicalTranscriptionJobRequest;
import com.amazonaws.services.transcribe.model.DeleteMedicalTranscriptionJobResult;
import com.amazonaws.services.transcribe.model.DeleteMedicalVocabularyRequest;
import com.amazonaws.services.transcribe.model.DeleteMedicalVocabularyResult;
import com.amazonaws.services.transcribe.model.DeleteTranscriptionJobRequest;
import com.amazonaws.services.transcribe.model.DeleteTranscriptionJobResult;
import com.amazonaws.services.transcribe.model.DeleteVocabularyFilterRequest;
import com.amazonaws.services.transcribe.model.DeleteVocabularyFilterResult;
import com.amazonaws.services.transcribe.model.DeleteVocabularyRequest;
import com.amazonaws.services.transcribe.model.DeleteVocabularyResult;
import com.amazonaws.services.transcribe.model.DescribeLanguageModelRequest;
import com.amazonaws.services.transcribe.model.DescribeLanguageModelResult;
import com.amazonaws.services.transcribe.model.GetMedicalTranscriptionJobRequest;
import com.amazonaws.services.transcribe.model.GetMedicalTranscriptionJobResult;
import com.amazonaws.services.transcribe.model.GetMedicalVocabularyRequest;
import com.amazonaws.services.transcribe.model.GetMedicalVocabularyResult;
import com.amazonaws.services.transcribe.model.GetTranscriptionJobRequest;
import com.amazonaws.services.transcribe.model.GetTranscriptionJobResult;
import com.amazonaws.services.transcribe.model.GetVocabularyFilterRequest;
import com.amazonaws.services.transcribe.model.GetVocabularyFilterResult;
import com.amazonaws.services.transcribe.model.GetVocabularyRequest;
import com.amazonaws.services.transcribe.model.GetVocabularyResult;
import com.amazonaws.services.transcribe.model.ListLanguageModelsRequest;
import com.amazonaws.services.transcribe.model.ListLanguageModelsResult;
import com.amazonaws.services.transcribe.model.ListMedicalTranscriptionJobsRequest;
import com.amazonaws.services.transcribe.model.ListMedicalTranscriptionJobsResult;
import com.amazonaws.services.transcribe.model.ListMedicalVocabulariesRequest;
import com.amazonaws.services.transcribe.model.ListMedicalVocabulariesResult;
import com.amazonaws.services.transcribe.model.ListTranscriptionJobsRequest;
import com.amazonaws.services.transcribe.model.ListTranscriptionJobsResult;
import com.amazonaws.services.transcribe.model.ListVocabulariesRequest;
import com.amazonaws.services.transcribe.model.ListVocabulariesResult;
import com.amazonaws.services.transcribe.model.ListVocabularyFiltersRequest;
import com.amazonaws.services.transcribe.model.ListVocabularyFiltersResult;
import com.amazonaws.services.transcribe.model.StartMedicalTranscriptionJobRequest;
import com.amazonaws.services.transcribe.model.StartMedicalTranscriptionJobResult;
import com.amazonaws.services.transcribe.model.StartTranscriptionJobRequest;
import com.amazonaws.services.transcribe.model.StartTranscriptionJobResult;
import com.amazonaws.services.transcribe.model.UpdateMedicalVocabularyRequest;
import com.amazonaws.services.transcribe.model.UpdateMedicalVocabularyResult;
import com.amazonaws.services.transcribe.model.UpdateVocabularyFilterRequest;
import com.amazonaws.services.transcribe.model.UpdateVocabularyFilterResult;
import com.amazonaws.services.transcribe.model.UpdateVocabularyRequest;
import com.amazonaws.services.transcribe.model.UpdateVocabularyResult;
import com.amazonaws.services.transcribe.model.transform.BadRequestExceptionUnmarshaller;
import com.amazonaws.services.transcribe.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.transcribe.model.transform.CreateLanguageModelRequestProtocolMarshaller;
import com.amazonaws.services.transcribe.model.transform.CreateLanguageModelResultJsonUnmarshaller;
import com.amazonaws.services.transcribe.model.transform.CreateMedicalVocabularyRequestProtocolMarshaller;
import com.amazonaws.services.transcribe.model.transform.CreateMedicalVocabularyResultJsonUnmarshaller;
import com.amazonaws.services.transcribe.model.transform.CreateVocabularyFilterRequestProtocolMarshaller;
import com.amazonaws.services.transcribe.model.transform.CreateVocabularyFilterResultJsonUnmarshaller;
import com.amazonaws.services.transcribe.model.transform.CreateVocabularyRequestProtocolMarshaller;
import com.amazonaws.services.transcribe.model.transform.CreateVocabularyResultJsonUnmarshaller;
import com.amazonaws.services.transcribe.model.transform.DeleteLanguageModelRequestProtocolMarshaller;
import com.amazonaws.services.transcribe.model.transform.DeleteLanguageModelResultJsonUnmarshaller;
import com.amazonaws.services.transcribe.model.transform.DeleteMedicalTranscriptionJobRequestProtocolMarshaller;
import com.amazonaws.services.transcribe.model.transform.DeleteMedicalTranscriptionJobResultJsonUnmarshaller;
import com.amazonaws.services.transcribe.model.transform.DeleteMedicalVocabularyRequestProtocolMarshaller;
import com.amazonaws.services.transcribe.model.transform.DeleteMedicalVocabularyResultJsonUnmarshaller;
import com.amazonaws.services.transcribe.model.transform.DeleteTranscriptionJobRequestProtocolMarshaller;
import com.amazonaws.services.transcribe.model.transform.DeleteTranscriptionJobResultJsonUnmarshaller;
import com.amazonaws.services.transcribe.model.transform.DeleteVocabularyFilterRequestProtocolMarshaller;
import com.amazonaws.services.transcribe.model.transform.DeleteVocabularyFilterResultJsonUnmarshaller;
import com.amazonaws.services.transcribe.model.transform.DeleteVocabularyRequestProtocolMarshaller;
import com.amazonaws.services.transcribe.model.transform.DeleteVocabularyResultJsonUnmarshaller;
import com.amazonaws.services.transcribe.model.transform.DescribeLanguageModelRequestProtocolMarshaller;
import com.amazonaws.services.transcribe.model.transform.DescribeLanguageModelResultJsonUnmarshaller;
import com.amazonaws.services.transcribe.model.transform.GetMedicalTranscriptionJobRequestProtocolMarshaller;
import com.amazonaws.services.transcribe.model.transform.GetMedicalTranscriptionJobResultJsonUnmarshaller;
import com.amazonaws.services.transcribe.model.transform.GetMedicalVocabularyRequestProtocolMarshaller;
import com.amazonaws.services.transcribe.model.transform.GetMedicalVocabularyResultJsonUnmarshaller;
import com.amazonaws.services.transcribe.model.transform.GetTranscriptionJobRequestProtocolMarshaller;
import com.amazonaws.services.transcribe.model.transform.GetTranscriptionJobResultJsonUnmarshaller;
import com.amazonaws.services.transcribe.model.transform.GetVocabularyFilterRequestProtocolMarshaller;
import com.amazonaws.services.transcribe.model.transform.GetVocabularyFilterResultJsonUnmarshaller;
import com.amazonaws.services.transcribe.model.transform.GetVocabularyRequestProtocolMarshaller;
import com.amazonaws.services.transcribe.model.transform.GetVocabularyResultJsonUnmarshaller;
import com.amazonaws.services.transcribe.model.transform.InternalFailureExceptionUnmarshaller;
import com.amazonaws.services.transcribe.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.transcribe.model.transform.ListLanguageModelsRequestProtocolMarshaller;
import com.amazonaws.services.transcribe.model.transform.ListLanguageModelsResultJsonUnmarshaller;
import com.amazonaws.services.transcribe.model.transform.ListMedicalTranscriptionJobsRequestProtocolMarshaller;
import com.amazonaws.services.transcribe.model.transform.ListMedicalTranscriptionJobsResultJsonUnmarshaller;
import com.amazonaws.services.transcribe.model.transform.ListMedicalVocabulariesRequestProtocolMarshaller;
import com.amazonaws.services.transcribe.model.transform.ListMedicalVocabulariesResultJsonUnmarshaller;
import com.amazonaws.services.transcribe.model.transform.ListTranscriptionJobsRequestProtocolMarshaller;
import com.amazonaws.services.transcribe.model.transform.ListTranscriptionJobsResultJsonUnmarshaller;
import com.amazonaws.services.transcribe.model.transform.ListVocabulariesRequestProtocolMarshaller;
import com.amazonaws.services.transcribe.model.transform.ListVocabulariesResultJsonUnmarshaller;
import com.amazonaws.services.transcribe.model.transform.ListVocabularyFiltersRequestProtocolMarshaller;
import com.amazonaws.services.transcribe.model.transform.ListVocabularyFiltersResultJsonUnmarshaller;
import com.amazonaws.services.transcribe.model.transform.NotFoundExceptionUnmarshaller;
import com.amazonaws.services.transcribe.model.transform.StartMedicalTranscriptionJobRequestProtocolMarshaller;
import com.amazonaws.services.transcribe.model.transform.StartMedicalTranscriptionJobResultJsonUnmarshaller;
import com.amazonaws.services.transcribe.model.transform.StartTranscriptionJobRequestProtocolMarshaller;
import com.amazonaws.services.transcribe.model.transform.StartTranscriptionJobResultJsonUnmarshaller;
import com.amazonaws.services.transcribe.model.transform.UpdateMedicalVocabularyRequestProtocolMarshaller;
import com.amazonaws.services.transcribe.model.transform.UpdateMedicalVocabularyResultJsonUnmarshaller;
import com.amazonaws.services.transcribe.model.transform.UpdateVocabularyFilterRequestProtocolMarshaller;
import com.amazonaws.services.transcribe.model.transform.UpdateVocabularyFilterResultJsonUnmarshaller;
import com.amazonaws.services.transcribe.model.transform.UpdateVocabularyRequestProtocolMarshaller;
import com.amazonaws.services.transcribe.model.transform.UpdateVocabularyResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonTranscribeClient
extends AmazonWebServiceClient
implements AmazonTranscribe {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonTranscribe.class);
    private static final String DEFAULT_SIGNING_NAME = "transcribe";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalFailureException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalFailureExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)NotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadRequestException").withExceptionUnmarshaller((JsonErrorUnmarshaller)BadRequestExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)LimitExceededExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonTranscribeException.class));

    public static AmazonTranscribeClientBuilder builder() {
        return AmazonTranscribeClientBuilder.standard();
    }

    AmazonTranscribeClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonTranscribeClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("transcribe.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/transcribe/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/transcribe/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateLanguageModelResult createLanguageModel(CreateLanguageModelRequest request) {
        request = (CreateLanguageModelRequest)this.beforeClientExecution(request);
        return this.executeCreateLanguageModel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateLanguageModelResult executeCreateLanguageModel(CreateLanguageModelRequest createLanguageModelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createLanguageModelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateLanguageModelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateLanguageModelRequestProtocolMarshaller(protocolFactory).marshall((CreateLanguageModelRequest)super.beforeMarshalling((AmazonWebServiceRequest)createLanguageModelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Transcribe");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateLanguageModel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateLanguageModelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateLanguageModelResult createLanguageModelResult = (CreateLanguageModelResult)response.getAwsResponse();
            return createLanguageModelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateMedicalVocabularyResult createMedicalVocabulary(CreateMedicalVocabularyRequest request) {
        request = (CreateMedicalVocabularyRequest)this.beforeClientExecution(request);
        return this.executeCreateMedicalVocabulary(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateMedicalVocabularyResult executeCreateMedicalVocabulary(CreateMedicalVocabularyRequest createMedicalVocabularyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createMedicalVocabularyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateMedicalVocabularyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateMedicalVocabularyRequestProtocolMarshaller(protocolFactory).marshall((CreateMedicalVocabularyRequest)super.beforeMarshalling((AmazonWebServiceRequest)createMedicalVocabularyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Transcribe");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateMedicalVocabulary");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateMedicalVocabularyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateMedicalVocabularyResult createMedicalVocabularyResult = (CreateMedicalVocabularyResult)response.getAwsResponse();
            return createMedicalVocabularyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateVocabularyResult createVocabulary(CreateVocabularyRequest request) {
        request = (CreateVocabularyRequest)this.beforeClientExecution(request);
        return this.executeCreateVocabulary(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateVocabularyResult executeCreateVocabulary(CreateVocabularyRequest createVocabularyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createVocabularyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateVocabularyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateVocabularyRequestProtocolMarshaller(protocolFactory).marshall((CreateVocabularyRequest)super.beforeMarshalling((AmazonWebServiceRequest)createVocabularyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Transcribe");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateVocabulary");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateVocabularyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateVocabularyResult createVocabularyResult = (CreateVocabularyResult)response.getAwsResponse();
            return createVocabularyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateVocabularyFilterResult createVocabularyFilter(CreateVocabularyFilterRequest request) {
        request = (CreateVocabularyFilterRequest)this.beforeClientExecution(request);
        return this.executeCreateVocabularyFilter(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateVocabularyFilterResult executeCreateVocabularyFilter(CreateVocabularyFilterRequest createVocabularyFilterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createVocabularyFilterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateVocabularyFilterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateVocabularyFilterRequestProtocolMarshaller(protocolFactory).marshall((CreateVocabularyFilterRequest)super.beforeMarshalling((AmazonWebServiceRequest)createVocabularyFilterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Transcribe");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateVocabularyFilter");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateVocabularyFilterResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateVocabularyFilterResult createVocabularyFilterResult = (CreateVocabularyFilterResult)response.getAwsResponse();
            return createVocabularyFilterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteLanguageModelResult deleteLanguageModel(DeleteLanguageModelRequest request) {
        request = (DeleteLanguageModelRequest)this.beforeClientExecution(request);
        return this.executeDeleteLanguageModel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteLanguageModelResult executeDeleteLanguageModel(DeleteLanguageModelRequest deleteLanguageModelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteLanguageModelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteLanguageModelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteLanguageModelRequestProtocolMarshaller(protocolFactory).marshall((DeleteLanguageModelRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteLanguageModelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Transcribe");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteLanguageModel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteLanguageModelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteLanguageModelResult deleteLanguageModelResult = (DeleteLanguageModelResult)response.getAwsResponse();
            return deleteLanguageModelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteMedicalTranscriptionJobResult deleteMedicalTranscriptionJob(DeleteMedicalTranscriptionJobRequest request) {
        request = (DeleteMedicalTranscriptionJobRequest)this.beforeClientExecution(request);
        return this.executeDeleteMedicalTranscriptionJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteMedicalTranscriptionJobResult executeDeleteMedicalTranscriptionJob(DeleteMedicalTranscriptionJobRequest deleteMedicalTranscriptionJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteMedicalTranscriptionJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteMedicalTranscriptionJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteMedicalTranscriptionJobRequestProtocolMarshaller(protocolFactory).marshall((DeleteMedicalTranscriptionJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteMedicalTranscriptionJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Transcribe");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteMedicalTranscriptionJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteMedicalTranscriptionJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteMedicalTranscriptionJobResult deleteMedicalTranscriptionJobResult = (DeleteMedicalTranscriptionJobResult)response.getAwsResponse();
            return deleteMedicalTranscriptionJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteMedicalVocabularyResult deleteMedicalVocabulary(DeleteMedicalVocabularyRequest request) {
        request = (DeleteMedicalVocabularyRequest)this.beforeClientExecution(request);
        return this.executeDeleteMedicalVocabulary(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteMedicalVocabularyResult executeDeleteMedicalVocabulary(DeleteMedicalVocabularyRequest deleteMedicalVocabularyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteMedicalVocabularyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteMedicalVocabularyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteMedicalVocabularyRequestProtocolMarshaller(protocolFactory).marshall((DeleteMedicalVocabularyRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteMedicalVocabularyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Transcribe");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteMedicalVocabulary");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteMedicalVocabularyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteMedicalVocabularyResult deleteMedicalVocabularyResult = (DeleteMedicalVocabularyResult)response.getAwsResponse();
            return deleteMedicalVocabularyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteTranscriptionJobResult deleteTranscriptionJob(DeleteTranscriptionJobRequest request) {
        request = (DeleteTranscriptionJobRequest)this.beforeClientExecution(request);
        return this.executeDeleteTranscriptionJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteTranscriptionJobResult executeDeleteTranscriptionJob(DeleteTranscriptionJobRequest deleteTranscriptionJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteTranscriptionJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteTranscriptionJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteTranscriptionJobRequestProtocolMarshaller(protocolFactory).marshall((DeleteTranscriptionJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteTranscriptionJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Transcribe");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteTranscriptionJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteTranscriptionJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteTranscriptionJobResult deleteTranscriptionJobResult = (DeleteTranscriptionJobResult)response.getAwsResponse();
            return deleteTranscriptionJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteVocabularyResult deleteVocabulary(DeleteVocabularyRequest request) {
        request = (DeleteVocabularyRequest)this.beforeClientExecution(request);
        return this.executeDeleteVocabulary(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteVocabularyResult executeDeleteVocabulary(DeleteVocabularyRequest deleteVocabularyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteVocabularyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteVocabularyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteVocabularyRequestProtocolMarshaller(protocolFactory).marshall((DeleteVocabularyRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteVocabularyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Transcribe");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteVocabulary");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteVocabularyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteVocabularyResult deleteVocabularyResult = (DeleteVocabularyResult)response.getAwsResponse();
            return deleteVocabularyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteVocabularyFilterResult deleteVocabularyFilter(DeleteVocabularyFilterRequest request) {
        request = (DeleteVocabularyFilterRequest)this.beforeClientExecution(request);
        return this.executeDeleteVocabularyFilter(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteVocabularyFilterResult executeDeleteVocabularyFilter(DeleteVocabularyFilterRequest deleteVocabularyFilterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteVocabularyFilterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteVocabularyFilterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteVocabularyFilterRequestProtocolMarshaller(protocolFactory).marshall((DeleteVocabularyFilterRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteVocabularyFilterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Transcribe");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteVocabularyFilter");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteVocabularyFilterResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteVocabularyFilterResult deleteVocabularyFilterResult = (DeleteVocabularyFilterResult)response.getAwsResponse();
            return deleteVocabularyFilterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeLanguageModelResult describeLanguageModel(DescribeLanguageModelRequest request) {
        request = (DescribeLanguageModelRequest)this.beforeClientExecution(request);
        return this.executeDescribeLanguageModel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeLanguageModelResult executeDescribeLanguageModel(DescribeLanguageModelRequest describeLanguageModelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeLanguageModelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeLanguageModelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeLanguageModelRequestProtocolMarshaller(protocolFactory).marshall((DescribeLanguageModelRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeLanguageModelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Transcribe");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeLanguageModel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeLanguageModelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeLanguageModelResult describeLanguageModelResult = (DescribeLanguageModelResult)response.getAwsResponse();
            return describeLanguageModelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetMedicalTranscriptionJobResult getMedicalTranscriptionJob(GetMedicalTranscriptionJobRequest request) {
        request = (GetMedicalTranscriptionJobRequest)this.beforeClientExecution(request);
        return this.executeGetMedicalTranscriptionJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetMedicalTranscriptionJobResult executeGetMedicalTranscriptionJob(GetMedicalTranscriptionJobRequest getMedicalTranscriptionJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getMedicalTranscriptionJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetMedicalTranscriptionJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetMedicalTranscriptionJobRequestProtocolMarshaller(protocolFactory).marshall((GetMedicalTranscriptionJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)getMedicalTranscriptionJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Transcribe");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetMedicalTranscriptionJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetMedicalTranscriptionJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetMedicalTranscriptionJobResult getMedicalTranscriptionJobResult = (GetMedicalTranscriptionJobResult)response.getAwsResponse();
            return getMedicalTranscriptionJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetMedicalVocabularyResult getMedicalVocabulary(GetMedicalVocabularyRequest request) {
        request = (GetMedicalVocabularyRequest)this.beforeClientExecution(request);
        return this.executeGetMedicalVocabulary(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetMedicalVocabularyResult executeGetMedicalVocabulary(GetMedicalVocabularyRequest getMedicalVocabularyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getMedicalVocabularyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetMedicalVocabularyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetMedicalVocabularyRequestProtocolMarshaller(protocolFactory).marshall((GetMedicalVocabularyRequest)super.beforeMarshalling((AmazonWebServiceRequest)getMedicalVocabularyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Transcribe");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetMedicalVocabulary");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetMedicalVocabularyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetMedicalVocabularyResult getMedicalVocabularyResult = (GetMedicalVocabularyResult)response.getAwsResponse();
            return getMedicalVocabularyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetTranscriptionJobResult getTranscriptionJob(GetTranscriptionJobRequest request) {
        request = (GetTranscriptionJobRequest)this.beforeClientExecution(request);
        return this.executeGetTranscriptionJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetTranscriptionJobResult executeGetTranscriptionJob(GetTranscriptionJobRequest getTranscriptionJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getTranscriptionJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetTranscriptionJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetTranscriptionJobRequestProtocolMarshaller(protocolFactory).marshall((GetTranscriptionJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)getTranscriptionJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Transcribe");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetTranscriptionJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetTranscriptionJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetTranscriptionJobResult getTranscriptionJobResult = (GetTranscriptionJobResult)response.getAwsResponse();
            return getTranscriptionJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetVocabularyResult getVocabulary(GetVocabularyRequest request) {
        request = (GetVocabularyRequest)this.beforeClientExecution(request);
        return this.executeGetVocabulary(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetVocabularyResult executeGetVocabulary(GetVocabularyRequest getVocabularyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getVocabularyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetVocabularyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetVocabularyRequestProtocolMarshaller(protocolFactory).marshall((GetVocabularyRequest)super.beforeMarshalling((AmazonWebServiceRequest)getVocabularyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Transcribe");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetVocabulary");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetVocabularyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetVocabularyResult getVocabularyResult = (GetVocabularyResult)response.getAwsResponse();
            return getVocabularyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetVocabularyFilterResult getVocabularyFilter(GetVocabularyFilterRequest request) {
        request = (GetVocabularyFilterRequest)this.beforeClientExecution(request);
        return this.executeGetVocabularyFilter(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetVocabularyFilterResult executeGetVocabularyFilter(GetVocabularyFilterRequest getVocabularyFilterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getVocabularyFilterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetVocabularyFilterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetVocabularyFilterRequestProtocolMarshaller(protocolFactory).marshall((GetVocabularyFilterRequest)super.beforeMarshalling((AmazonWebServiceRequest)getVocabularyFilterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Transcribe");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetVocabularyFilter");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetVocabularyFilterResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetVocabularyFilterResult getVocabularyFilterResult = (GetVocabularyFilterResult)response.getAwsResponse();
            return getVocabularyFilterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListLanguageModelsResult listLanguageModels(ListLanguageModelsRequest request) {
        request = (ListLanguageModelsRequest)this.beforeClientExecution(request);
        return this.executeListLanguageModels(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListLanguageModelsResult executeListLanguageModels(ListLanguageModelsRequest listLanguageModelsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listLanguageModelsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListLanguageModelsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListLanguageModelsRequestProtocolMarshaller(protocolFactory).marshall((ListLanguageModelsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listLanguageModelsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Transcribe");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListLanguageModels");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListLanguageModelsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListLanguageModelsResult listLanguageModelsResult = (ListLanguageModelsResult)response.getAwsResponse();
            return listLanguageModelsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListMedicalTranscriptionJobsResult listMedicalTranscriptionJobs(ListMedicalTranscriptionJobsRequest request) {
        request = (ListMedicalTranscriptionJobsRequest)this.beforeClientExecution(request);
        return this.executeListMedicalTranscriptionJobs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListMedicalTranscriptionJobsResult executeListMedicalTranscriptionJobs(ListMedicalTranscriptionJobsRequest listMedicalTranscriptionJobsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listMedicalTranscriptionJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListMedicalTranscriptionJobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListMedicalTranscriptionJobsRequestProtocolMarshaller(protocolFactory).marshall((ListMedicalTranscriptionJobsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listMedicalTranscriptionJobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Transcribe");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListMedicalTranscriptionJobs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListMedicalTranscriptionJobsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListMedicalTranscriptionJobsResult listMedicalTranscriptionJobsResult = (ListMedicalTranscriptionJobsResult)response.getAwsResponse();
            return listMedicalTranscriptionJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListMedicalVocabulariesResult listMedicalVocabularies(ListMedicalVocabulariesRequest request) {
        request = (ListMedicalVocabulariesRequest)this.beforeClientExecution(request);
        return this.executeListMedicalVocabularies(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListMedicalVocabulariesResult executeListMedicalVocabularies(ListMedicalVocabulariesRequest listMedicalVocabulariesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listMedicalVocabulariesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListMedicalVocabulariesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListMedicalVocabulariesRequestProtocolMarshaller(protocolFactory).marshall((ListMedicalVocabulariesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listMedicalVocabulariesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Transcribe");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListMedicalVocabularies");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListMedicalVocabulariesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListMedicalVocabulariesResult listMedicalVocabulariesResult = (ListMedicalVocabulariesResult)response.getAwsResponse();
            return listMedicalVocabulariesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTranscriptionJobsResult listTranscriptionJobs(ListTranscriptionJobsRequest request) {
        request = (ListTranscriptionJobsRequest)this.beforeClientExecution(request);
        return this.executeListTranscriptionJobs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTranscriptionJobsResult executeListTranscriptionJobs(ListTranscriptionJobsRequest listTranscriptionJobsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTranscriptionJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTranscriptionJobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTranscriptionJobsRequestProtocolMarshaller(protocolFactory).marshall((ListTranscriptionJobsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTranscriptionJobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Transcribe");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTranscriptionJobs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTranscriptionJobsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTranscriptionJobsResult listTranscriptionJobsResult = (ListTranscriptionJobsResult)response.getAwsResponse();
            return listTranscriptionJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListVocabulariesResult listVocabularies(ListVocabulariesRequest request) {
        request = (ListVocabulariesRequest)this.beforeClientExecution(request);
        return this.executeListVocabularies(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListVocabulariesResult executeListVocabularies(ListVocabulariesRequest listVocabulariesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listVocabulariesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListVocabulariesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListVocabulariesRequestProtocolMarshaller(protocolFactory).marshall((ListVocabulariesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listVocabulariesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Transcribe");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListVocabularies");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListVocabulariesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListVocabulariesResult listVocabulariesResult = (ListVocabulariesResult)response.getAwsResponse();
            return listVocabulariesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListVocabularyFiltersResult listVocabularyFilters(ListVocabularyFiltersRequest request) {
        request = (ListVocabularyFiltersRequest)this.beforeClientExecution(request);
        return this.executeListVocabularyFilters(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListVocabularyFiltersResult executeListVocabularyFilters(ListVocabularyFiltersRequest listVocabularyFiltersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listVocabularyFiltersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListVocabularyFiltersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListVocabularyFiltersRequestProtocolMarshaller(protocolFactory).marshall((ListVocabularyFiltersRequest)super.beforeMarshalling((AmazonWebServiceRequest)listVocabularyFiltersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Transcribe");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListVocabularyFilters");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListVocabularyFiltersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListVocabularyFiltersResult listVocabularyFiltersResult = (ListVocabularyFiltersResult)response.getAwsResponse();
            return listVocabularyFiltersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartMedicalTranscriptionJobResult startMedicalTranscriptionJob(StartMedicalTranscriptionJobRequest request) {
        request = (StartMedicalTranscriptionJobRequest)this.beforeClientExecution(request);
        return this.executeStartMedicalTranscriptionJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartMedicalTranscriptionJobResult executeStartMedicalTranscriptionJob(StartMedicalTranscriptionJobRequest startMedicalTranscriptionJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startMedicalTranscriptionJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartMedicalTranscriptionJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartMedicalTranscriptionJobRequestProtocolMarshaller(protocolFactory).marshall((StartMedicalTranscriptionJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)startMedicalTranscriptionJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Transcribe");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartMedicalTranscriptionJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartMedicalTranscriptionJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartMedicalTranscriptionJobResult startMedicalTranscriptionJobResult = (StartMedicalTranscriptionJobResult)response.getAwsResponse();
            return startMedicalTranscriptionJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartTranscriptionJobResult startTranscriptionJob(StartTranscriptionJobRequest request) {
        request = (StartTranscriptionJobRequest)this.beforeClientExecution(request);
        return this.executeStartTranscriptionJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartTranscriptionJobResult executeStartTranscriptionJob(StartTranscriptionJobRequest startTranscriptionJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startTranscriptionJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartTranscriptionJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartTranscriptionJobRequestProtocolMarshaller(protocolFactory).marshall((StartTranscriptionJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)startTranscriptionJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Transcribe");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartTranscriptionJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartTranscriptionJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartTranscriptionJobResult startTranscriptionJobResult = (StartTranscriptionJobResult)response.getAwsResponse();
            return startTranscriptionJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateMedicalVocabularyResult updateMedicalVocabulary(UpdateMedicalVocabularyRequest request) {
        request = (UpdateMedicalVocabularyRequest)this.beforeClientExecution(request);
        return this.executeUpdateMedicalVocabulary(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateMedicalVocabularyResult executeUpdateMedicalVocabulary(UpdateMedicalVocabularyRequest updateMedicalVocabularyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateMedicalVocabularyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateMedicalVocabularyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateMedicalVocabularyRequestProtocolMarshaller(protocolFactory).marshall((UpdateMedicalVocabularyRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateMedicalVocabularyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Transcribe");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateMedicalVocabulary");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateMedicalVocabularyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateMedicalVocabularyResult updateMedicalVocabularyResult = (UpdateMedicalVocabularyResult)response.getAwsResponse();
            return updateMedicalVocabularyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateVocabularyResult updateVocabulary(UpdateVocabularyRequest request) {
        request = (UpdateVocabularyRequest)this.beforeClientExecution(request);
        return this.executeUpdateVocabulary(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateVocabularyResult executeUpdateVocabulary(UpdateVocabularyRequest updateVocabularyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateVocabularyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateVocabularyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateVocabularyRequestProtocolMarshaller(protocolFactory).marshall((UpdateVocabularyRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateVocabularyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Transcribe");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateVocabulary");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateVocabularyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateVocabularyResult updateVocabularyResult = (UpdateVocabularyResult)response.getAwsResponse();
            return updateVocabularyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateVocabularyFilterResult updateVocabularyFilter(UpdateVocabularyFilterRequest request) {
        request = (UpdateVocabularyFilterRequest)this.beforeClientExecution(request);
        return this.executeUpdateVocabularyFilter(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateVocabularyFilterResult executeUpdateVocabularyFilter(UpdateVocabularyFilterRequest updateVocabularyFilterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateVocabularyFilterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateVocabularyFilterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateVocabularyFilterRequestProtocolMarshaller(protocolFactory).marshall((UpdateVocabularyFilterRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateVocabularyFilterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Transcribe");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateVocabularyFilter");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateVocabularyFilterResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateVocabularyFilterResult updateVocabularyFilterResult = (UpdateVocabularyFilterResult)response.getAwsResponse();
            return updateVocabularyFilterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

