/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transcribe.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.transcribe.model.TranscriptionJobStatus;
import com.amazonaws.services.transcribe.model.VocabularyInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListVocabulariesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String status;
    private String nextToken;
    private List<VocabularyInfo> vocabularies;

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public ListVocabulariesResult withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public ListVocabulariesResult withStatus(TranscriptionJobStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListVocabulariesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<VocabularyInfo> getVocabularies() {
        return this.vocabularies;
    }

    public void setVocabularies(Collection<VocabularyInfo> vocabularies) {
        if (vocabularies == null) {
            this.vocabularies = null;
            return;
        }
        this.vocabularies = new ArrayList<VocabularyInfo>(vocabularies);
    }

    public ListVocabulariesResult withVocabularies(VocabularyInfo ... vocabularies) {
        if (this.vocabularies == null) {
            this.setVocabularies(new ArrayList<VocabularyInfo>(vocabularies.length));
        }
        for (VocabularyInfo ele : vocabularies) {
            this.vocabularies.add(ele);
        }
        return this;
    }

    public ListVocabulariesResult withVocabularies(Collection<VocabularyInfo> vocabularies) {
        this.setVocabularies(vocabularies);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getVocabularies() != null) {
            sb.append("Vocabularies: ").append(this.getVocabularies());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVocabulariesResult)) {
            return false;
        }
        ListVocabulariesResult other = (ListVocabulariesResult)obj;
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getVocabularies() == null ^ this.getVocabularies() == null) {
            return false;
        }
        return other.getVocabularies() == null || other.getVocabularies().equals(this.getVocabularies());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getVocabularies() == null ? 0 : this.getVocabularies().hashCode());
        return hashCode;
    }

    public ListVocabulariesResult clone() {
        try {
            return (ListVocabulariesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

