/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.timestreamwrite.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.timestreamwrite.model.DataSourceS3Configuration;

@SdkInternalApi
public class DataSourceS3ConfigurationMarshaller {
    private static final MarshallingInfo<String> BUCKETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BucketName").build();
    private static final MarshallingInfo<String> OBJECTKEYPREFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ObjectKeyPrefix").build();
    private static final DataSourceS3ConfigurationMarshaller instance = new DataSourceS3ConfigurationMarshaller();

    public static DataSourceS3ConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(DataSourceS3Configuration dataSourceS3Configuration, ProtocolMarshaller protocolMarshaller) {
        if (dataSourceS3Configuration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)dataSourceS3Configuration.getBucketName(), BUCKETNAME_BINDING);
            protocolMarshaller.marshall((Object)dataSourceS3Configuration.getObjectKeyPrefix(), OBJECTKEYPREFIX_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

