/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.timestreamwrite.endpointdiscovery;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.cache.EndpointDiscoveryCacheLoader;
import com.amazonaws.services.timestreamwrite.AmazonTimestreamWrite;
import com.amazonaws.services.timestreamwrite.model.DescribeEndpointsRequest;
import com.amazonaws.services.timestreamwrite.model.DescribeEndpointsResult;
import com.amazonaws.services.timestreamwrite.model.Endpoint;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AmazonTimestreamWriteEndpointCacheLoader
implements EndpointDiscoveryCacheLoader<String, Map<String, String>> {
    private final AmazonTimestreamWrite client;

    public AmazonTimestreamWriteEndpointCacheLoader(AmazonTimestreamWrite client) {
        this.client = client;
    }

    public Map<String, String> load(String key, AmazonWebServiceRequest discoveryRequest) {
        DescribeEndpointsRequest request;
        DescribeEndpointsResult response;
        List<Endpoint> endpoints;
        if (discoveryRequest == null) {
            discoveryRequest = new DescribeEndpointsRequest();
        }
        if ((endpoints = (response = this.client.describeEndpoints(request = (DescribeEndpointsRequest)discoveryRequest)).getEndpoints()) == null || endpoints.size() == 0) {
            return null;
        }
        Endpoint endpoint = endpoints.get(0);
        HashMap<String, String> endpointDetail = new HashMap<String, String>();
        endpointDetail.put("CachePeriod", String.valueOf(endpoint.getCachePeriodInMinutes()));
        endpointDetail.put("Endpoint", endpoint.getAddress());
        return endpointDetail;
    }
}

