/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.timestreamquery.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.timestreamquery.model.ColumnInfo;
import com.amazonaws.services.timestreamquery.model.Row;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class QueryResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String queryId;
    private String nextToken;
    private List<Row> rows;
    private List<ColumnInfo> columnInfo;

    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public QueryResult withQueryId(String queryId) {
        this.setQueryId(queryId);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public QueryResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<Row> getRows() {
        return this.rows;
    }

    public void setRows(Collection<Row> rows) {
        if (rows == null) {
            this.rows = null;
            return;
        }
        this.rows = new ArrayList<Row>(rows);
    }

    public QueryResult withRows(Row ... rows) {
        if (this.rows == null) {
            this.setRows(new ArrayList<Row>(rows.length));
        }
        for (Row ele : rows) {
            this.rows.add(ele);
        }
        return this;
    }

    public QueryResult withRows(Collection<Row> rows) {
        this.setRows(rows);
        return this;
    }

    public List<ColumnInfo> getColumnInfo() {
        return this.columnInfo;
    }

    public void setColumnInfo(Collection<ColumnInfo> columnInfo) {
        if (columnInfo == null) {
            this.columnInfo = null;
            return;
        }
        this.columnInfo = new ArrayList<ColumnInfo>(columnInfo);
    }

    public QueryResult withColumnInfo(ColumnInfo ... columnInfo) {
        if (this.columnInfo == null) {
            this.setColumnInfo(new ArrayList<ColumnInfo>(columnInfo.length));
        }
        for (ColumnInfo ele : columnInfo) {
            this.columnInfo.add(ele);
        }
        return this;
    }

    public QueryResult withColumnInfo(Collection<ColumnInfo> columnInfo) {
        this.setColumnInfo(columnInfo);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getQueryId() != null) {
            sb.append("QueryId: ").append(this.getQueryId()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getRows() != null) {
            sb.append("Rows: ").append(this.getRows()).append(",");
        }
        if (this.getColumnInfo() != null) {
            sb.append("ColumnInfo: ").append(this.getColumnInfo());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryResult)) {
            return false;
        }
        QueryResult other = (QueryResult)obj;
        if (other.getQueryId() == null ^ this.getQueryId() == null) {
            return false;
        }
        if (other.getQueryId() != null && !other.getQueryId().equals(this.getQueryId())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getRows() == null ^ this.getRows() == null) {
            return false;
        }
        if (other.getRows() != null && !other.getRows().equals(this.getRows())) {
            return false;
        }
        if (other.getColumnInfo() == null ^ this.getColumnInfo() == null) {
            return false;
        }
        return other.getColumnInfo() == null || other.getColumnInfo().equals(this.getColumnInfo());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getQueryId() == null ? 0 : this.getQueryId().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getRows() == null ? 0 : this.getRows().hashCode());
        hashCode = 31 * hashCode + (this.getColumnInfo() == null ? 0 : this.getColumnInfo().hashCode());
        return hashCode;
    }

    public QueryResult clone() {
        try {
            return (QueryResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

