/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.textract.model.EvaluationMetric;

@SdkInternalApi
public class EvaluationMetricMarshaller {
    private static final MarshallingInfo<Float> F1SCORE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("F1Score").build();
    private static final MarshallingInfo<Float> PRECISION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Precision").build();
    private static final MarshallingInfo<Float> RECALL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Recall").build();
    private static final EvaluationMetricMarshaller instance = new EvaluationMetricMarshaller();

    public static EvaluationMetricMarshaller getInstance() {
        return instance;
    }

    public void marshall(EvaluationMetric evaluationMetric, ProtocolMarshaller protocolMarshaller) {
        if (evaluationMetric == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)evaluationMetric.getF1Score(), F1SCORE_BINDING);
            protocolMarshaller.marshall((Object)evaluationMetric.getPrecision(), PRECISION_BINDING);
            protocolMarshaller.marshall((Object)evaluationMetric.getRecall(), RECALL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

