/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.textract.model.AdapterVersionDatasetConfig;
import com.amazonaws.services.textract.model.AdapterVersionEvaluationMetric;
import com.amazonaws.services.textract.model.AdapterVersionStatus;
import com.amazonaws.services.textract.model.FeatureType;
import com.amazonaws.services.textract.model.OutputConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetAdapterVersionResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String adapterId;
    private String adapterVersion;
    private Date creationTime;
    private List<String> featureTypes;
    private String status;
    private String statusMessage;
    private AdapterVersionDatasetConfig datasetConfig;
    private String kMSKeyId;
    private OutputConfig outputConfig;
    private List<AdapterVersionEvaluationMetric> evaluationMetrics;
    private Map<String, String> tags;

    public void setAdapterId(String adapterId) {
        this.adapterId = adapterId;
    }

    public String getAdapterId() {
        return this.adapterId;
    }

    public GetAdapterVersionResult withAdapterId(String adapterId) {
        this.setAdapterId(adapterId);
        return this;
    }

    public void setAdapterVersion(String adapterVersion) {
        this.adapterVersion = adapterVersion;
    }

    public String getAdapterVersion() {
        return this.adapterVersion;
    }

    public GetAdapterVersionResult withAdapterVersion(String adapterVersion) {
        this.setAdapterVersion(adapterVersion);
        return this;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public GetAdapterVersionResult withCreationTime(Date creationTime) {
        this.setCreationTime(creationTime);
        return this;
    }

    public List<String> getFeatureTypes() {
        return this.featureTypes;
    }

    public void setFeatureTypes(Collection<String> featureTypes) {
        if (featureTypes == null) {
            this.featureTypes = null;
            return;
        }
        this.featureTypes = new ArrayList<String>(featureTypes);
    }

    public GetAdapterVersionResult withFeatureTypes(String ... featureTypes) {
        if (this.featureTypes == null) {
            this.setFeatureTypes(new ArrayList<String>(featureTypes.length));
        }
        for (String ele : featureTypes) {
            this.featureTypes.add(ele);
        }
        return this;
    }

    public GetAdapterVersionResult withFeatureTypes(Collection<String> featureTypes) {
        this.setFeatureTypes(featureTypes);
        return this;
    }

    public GetAdapterVersionResult withFeatureTypes(FeatureType ... featureTypes) {
        ArrayList<String> featureTypesCopy = new ArrayList<String>(featureTypes.length);
        for (FeatureType value : featureTypes) {
            featureTypesCopy.add(value.toString());
        }
        if (this.getFeatureTypes() == null) {
            this.setFeatureTypes(featureTypesCopy);
        } else {
            this.getFeatureTypes().addAll(featureTypesCopy);
        }
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public GetAdapterVersionResult withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public GetAdapterVersionResult withStatus(AdapterVersionStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public GetAdapterVersionResult withStatusMessage(String statusMessage) {
        this.setStatusMessage(statusMessage);
        return this;
    }

    public void setDatasetConfig(AdapterVersionDatasetConfig datasetConfig) {
        this.datasetConfig = datasetConfig;
    }

    public AdapterVersionDatasetConfig getDatasetConfig() {
        return this.datasetConfig;
    }

    public GetAdapterVersionResult withDatasetConfig(AdapterVersionDatasetConfig datasetConfig) {
        this.setDatasetConfig(datasetConfig);
        return this;
    }

    public void setKMSKeyId(String kMSKeyId) {
        this.kMSKeyId = kMSKeyId;
    }

    public String getKMSKeyId() {
        return this.kMSKeyId;
    }

    public GetAdapterVersionResult withKMSKeyId(String kMSKeyId) {
        this.setKMSKeyId(kMSKeyId);
        return this;
    }

    public void setOutputConfig(OutputConfig outputConfig) {
        this.outputConfig = outputConfig;
    }

    public OutputConfig getOutputConfig() {
        return this.outputConfig;
    }

    public GetAdapterVersionResult withOutputConfig(OutputConfig outputConfig) {
        this.setOutputConfig(outputConfig);
        return this;
    }

    public List<AdapterVersionEvaluationMetric> getEvaluationMetrics() {
        return this.evaluationMetrics;
    }

    public void setEvaluationMetrics(Collection<AdapterVersionEvaluationMetric> evaluationMetrics) {
        if (evaluationMetrics == null) {
            this.evaluationMetrics = null;
            return;
        }
        this.evaluationMetrics = new ArrayList<AdapterVersionEvaluationMetric>(evaluationMetrics);
    }

    public GetAdapterVersionResult withEvaluationMetrics(AdapterVersionEvaluationMetric ... evaluationMetrics) {
        if (this.evaluationMetrics == null) {
            this.setEvaluationMetrics(new ArrayList<AdapterVersionEvaluationMetric>(evaluationMetrics.length));
        }
        for (AdapterVersionEvaluationMetric ele : evaluationMetrics) {
            this.evaluationMetrics.add(ele);
        }
        return this;
    }

    public GetAdapterVersionResult withEvaluationMetrics(Collection<AdapterVersionEvaluationMetric> evaluationMetrics) {
        this.setEvaluationMetrics(evaluationMetrics);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public GetAdapterVersionResult withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public GetAdapterVersionResult addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public GetAdapterVersionResult clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAdapterId() != null) {
            sb.append("AdapterId: ").append(this.getAdapterId()).append(",");
        }
        if (this.getAdapterVersion() != null) {
            sb.append("AdapterVersion: ").append(this.getAdapterVersion()).append(",");
        }
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: ").append(this.getCreationTime()).append(",");
        }
        if (this.getFeatureTypes() != null) {
            sb.append("FeatureTypes: ").append(this.getFeatureTypes()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getStatusMessage() != null) {
            sb.append("StatusMessage: ").append(this.getStatusMessage()).append(",");
        }
        if (this.getDatasetConfig() != null) {
            sb.append("DatasetConfig: ").append(this.getDatasetConfig()).append(",");
        }
        if (this.getKMSKeyId() != null) {
            sb.append("KMSKeyId: ").append(this.getKMSKeyId()).append(",");
        }
        if (this.getOutputConfig() != null) {
            sb.append("OutputConfig: ").append(this.getOutputConfig()).append(",");
        }
        if (this.getEvaluationMetrics() != null) {
            sb.append("EvaluationMetrics: ").append(this.getEvaluationMetrics()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAdapterVersionResult)) {
            return false;
        }
        GetAdapterVersionResult other = (GetAdapterVersionResult)obj;
        if (other.getAdapterId() == null ^ this.getAdapterId() == null) {
            return false;
        }
        if (other.getAdapterId() != null && !other.getAdapterId().equals(this.getAdapterId())) {
            return false;
        }
        if (other.getAdapterVersion() == null ^ this.getAdapterVersion() == null) {
            return false;
        }
        if (other.getAdapterVersion() != null && !other.getAdapterVersion().equals(this.getAdapterVersion())) {
            return false;
        }
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        if (other.getCreationTime() != null && !other.getCreationTime().equals(this.getCreationTime())) {
            return false;
        }
        if (other.getFeatureTypes() == null ^ this.getFeatureTypes() == null) {
            return false;
        }
        if (other.getFeatureTypes() != null && !other.getFeatureTypes().equals(this.getFeatureTypes())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getStatusMessage() == null ^ this.getStatusMessage() == null) {
            return false;
        }
        if (other.getStatusMessage() != null && !other.getStatusMessage().equals(this.getStatusMessage())) {
            return false;
        }
        if (other.getDatasetConfig() == null ^ this.getDatasetConfig() == null) {
            return false;
        }
        if (other.getDatasetConfig() != null && !other.getDatasetConfig().equals(this.getDatasetConfig())) {
            return false;
        }
        if (other.getKMSKeyId() == null ^ this.getKMSKeyId() == null) {
            return false;
        }
        if (other.getKMSKeyId() != null && !other.getKMSKeyId().equals(this.getKMSKeyId())) {
            return false;
        }
        if (other.getOutputConfig() == null ^ this.getOutputConfig() == null) {
            return false;
        }
        if (other.getOutputConfig() != null && !other.getOutputConfig().equals(this.getOutputConfig())) {
            return false;
        }
        if (other.getEvaluationMetrics() == null ^ this.getEvaluationMetrics() == null) {
            return false;
        }
        if (other.getEvaluationMetrics() != null && !other.getEvaluationMetrics().equals(this.getEvaluationMetrics())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAdapterId() == null ? 0 : this.getAdapterId().hashCode());
        hashCode = 31 * hashCode + (this.getAdapterVersion() == null ? 0 : this.getAdapterVersion().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.getFeatureTypes() == null ? 0 : this.getFeatureTypes().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getStatusMessage() == null ? 0 : this.getStatusMessage().hashCode());
        hashCode = 31 * hashCode + (this.getDatasetConfig() == null ? 0 : this.getDatasetConfig().hashCode());
        hashCode = 31 * hashCode + (this.getKMSKeyId() == null ? 0 : this.getKMSKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getOutputConfig() == null ? 0 : this.getOutputConfig().hashCode());
        hashCode = 31 * hashCode + (this.getEvaluationMetrics() == null ? 0 : this.getEvaluationMetrics().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public GetAdapterVersionResult clone() {
        try {
            return (GetAdapterVersionResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

