/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model.transform;

import com.amazonaws.services.textract.model.DocumentGroup;
import com.amazonaws.services.textract.model.transform.DetectedSignatureJsonUnmarshaller;
import com.amazonaws.services.textract.model.transform.SplitDocumentJsonUnmarshaller;
import com.amazonaws.services.textract.model.transform.UndetectedSignatureJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.UnknownMemberJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class DocumentGroupJsonUnmarshaller
implements Unmarshaller<DocumentGroup, JsonUnmarshallerContext> {
    private static DocumentGroupJsonUnmarshaller instance;

    public DocumentGroup unmarshall(JsonUnmarshallerContext context) throws Exception {
        DocumentGroup documentGroup = new DocumentGroup();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            boolean knownMember = false;
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Type", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    documentGroup.setType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SplitDocuments", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    documentGroup.setSplitDocuments(new ListUnmarshaller((Unmarshaller)SplitDocumentJsonUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("DetectedSignatures", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    documentGroup.setDetectedSignatures(new ListUnmarshaller((Unmarshaller)DetectedSignatureJsonUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("UndetectedSignatures", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    documentGroup.setUndetectedSignatures(new ListUnmarshaller((Unmarshaller)UndetectedSignatureJsonUnmarshaller.getInstance()).unmarshall(context));
                }
                if (token == JsonToken.FIELD_NAME && !knownMember) {
                    context.nextToken();
                    UnknownMemberJsonUnmarshaller.getInstance().unmarshall(context);
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return documentGroup;
    }

    public static DocumentGroupJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DocumentGroupJsonUnmarshaller();
        }
        return instance;
    }
}

