/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.textract.model.Block;
import com.amazonaws.services.textract.model.ExpenseField;
import com.amazonaws.services.textract.model.LineItemGroup;
import com.amazonaws.services.textract.model.transform.ExpenseDocumentMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ExpenseDocument
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer expenseIndex;
    private List<ExpenseField> summaryFields;
    private List<LineItemGroup> lineItemGroups;
    private List<Block> blocks;

    public void setExpenseIndex(Integer expenseIndex) {
        this.expenseIndex = expenseIndex;
    }

    public Integer getExpenseIndex() {
        return this.expenseIndex;
    }

    public ExpenseDocument withExpenseIndex(Integer expenseIndex) {
        this.setExpenseIndex(expenseIndex);
        return this;
    }

    public List<ExpenseField> getSummaryFields() {
        return this.summaryFields;
    }

    public void setSummaryFields(Collection<ExpenseField> summaryFields) {
        if (summaryFields == null) {
            this.summaryFields = null;
            return;
        }
        this.summaryFields = new ArrayList<ExpenseField>(summaryFields);
    }

    public ExpenseDocument withSummaryFields(ExpenseField ... summaryFields) {
        if (this.summaryFields == null) {
            this.setSummaryFields(new ArrayList<ExpenseField>(summaryFields.length));
        }
        for (ExpenseField ele : summaryFields) {
            this.summaryFields.add(ele);
        }
        return this;
    }

    public ExpenseDocument withSummaryFields(Collection<ExpenseField> summaryFields) {
        this.setSummaryFields(summaryFields);
        return this;
    }

    public List<LineItemGroup> getLineItemGroups() {
        return this.lineItemGroups;
    }

    public void setLineItemGroups(Collection<LineItemGroup> lineItemGroups) {
        if (lineItemGroups == null) {
            this.lineItemGroups = null;
            return;
        }
        this.lineItemGroups = new ArrayList<LineItemGroup>(lineItemGroups);
    }

    public ExpenseDocument withLineItemGroups(LineItemGroup ... lineItemGroups) {
        if (this.lineItemGroups == null) {
            this.setLineItemGroups(new ArrayList<LineItemGroup>(lineItemGroups.length));
        }
        for (LineItemGroup ele : lineItemGroups) {
            this.lineItemGroups.add(ele);
        }
        return this;
    }

    public ExpenseDocument withLineItemGroups(Collection<LineItemGroup> lineItemGroups) {
        this.setLineItemGroups(lineItemGroups);
        return this;
    }

    public List<Block> getBlocks() {
        return this.blocks;
    }

    public void setBlocks(Collection<Block> blocks) {
        if (blocks == null) {
            this.blocks = null;
            return;
        }
        this.blocks = new ArrayList<Block>(blocks);
    }

    public ExpenseDocument withBlocks(Block ... blocks) {
        if (this.blocks == null) {
            this.setBlocks(new ArrayList<Block>(blocks.length));
        }
        for (Block ele : blocks) {
            this.blocks.add(ele);
        }
        return this;
    }

    public ExpenseDocument withBlocks(Collection<Block> blocks) {
        this.setBlocks(blocks);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getExpenseIndex() != null) {
            sb.append("ExpenseIndex: ").append(this.getExpenseIndex()).append(",");
        }
        if (this.getSummaryFields() != null) {
            sb.append("SummaryFields: ").append(this.getSummaryFields()).append(",");
        }
        if (this.getLineItemGroups() != null) {
            sb.append("LineItemGroups: ").append(this.getLineItemGroups()).append(",");
        }
        if (this.getBlocks() != null) {
            sb.append("Blocks: ").append(this.getBlocks());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExpenseDocument)) {
            return false;
        }
        ExpenseDocument other = (ExpenseDocument)obj;
        if (other.getExpenseIndex() == null ^ this.getExpenseIndex() == null) {
            return false;
        }
        if (other.getExpenseIndex() != null && !other.getExpenseIndex().equals(this.getExpenseIndex())) {
            return false;
        }
        if (other.getSummaryFields() == null ^ this.getSummaryFields() == null) {
            return false;
        }
        if (other.getSummaryFields() != null && !other.getSummaryFields().equals(this.getSummaryFields())) {
            return false;
        }
        if (other.getLineItemGroups() == null ^ this.getLineItemGroups() == null) {
            return false;
        }
        if (other.getLineItemGroups() != null && !other.getLineItemGroups().equals(this.getLineItemGroups())) {
            return false;
        }
        if (other.getBlocks() == null ^ this.getBlocks() == null) {
            return false;
        }
        return other.getBlocks() == null || other.getBlocks().equals(this.getBlocks());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getExpenseIndex() == null ? 0 : this.getExpenseIndex().hashCode());
        hashCode = 31 * hashCode + (this.getSummaryFields() == null ? 0 : this.getSummaryFields().hashCode());
        hashCode = 31 * hashCode + (this.getLineItemGroups() == null ? 0 : this.getLineItemGroups().hashCode());
        hashCode = 31 * hashCode + (this.getBlocks() == null ? 0 : this.getBlocks().hashCode());
        return hashCode;
    }

    public ExpenseDocument clone() {
        try {
            return (ExpenseDocument)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExpenseDocumentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

