/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.textract.model.LendingDocument;
import java.util.List;

@SdkInternalApi
public class LendingDocumentMarshaller {
    private static final MarshallingInfo<List> LENDINGFIELDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LendingFields").build();
    private static final MarshallingInfo<List> SIGNATUREDETECTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SignatureDetections").build();
    private static final LendingDocumentMarshaller instance = new LendingDocumentMarshaller();

    public static LendingDocumentMarshaller getInstance() {
        return instance;
    }

    public void marshall(LendingDocument lendingDocument, ProtocolMarshaller protocolMarshaller) {
        if (lendingDocument == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(lendingDocument.getLendingFields(), LENDINGFIELDS_BINDING);
            protocolMarshaller.marshall(lendingDocument.getSignatureDetections(), SIGNATUREDETECTIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

