/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.textract.model.ExpenseDetection;
import com.amazonaws.services.textract.model.ExpenseType;
import com.amazonaws.services.textract.model.transform.ExpenseFieldMarshaller;
import java.io.Serializable;

public class ExpenseField
implements Serializable,
Cloneable,
StructuredPojo {
    private ExpenseType type;
    private ExpenseDetection labelDetection;
    private ExpenseDetection valueDetection;
    private Integer pageNumber;

    public void setType(ExpenseType type) {
        this.type = type;
    }

    public ExpenseType getType() {
        return this.type;
    }

    public ExpenseField withType(ExpenseType type) {
        this.setType(type);
        return this;
    }

    public void setLabelDetection(ExpenseDetection labelDetection) {
        this.labelDetection = labelDetection;
    }

    public ExpenseDetection getLabelDetection() {
        return this.labelDetection;
    }

    public ExpenseField withLabelDetection(ExpenseDetection labelDetection) {
        this.setLabelDetection(labelDetection);
        return this;
    }

    public void setValueDetection(ExpenseDetection valueDetection) {
        this.valueDetection = valueDetection;
    }

    public ExpenseDetection getValueDetection() {
        return this.valueDetection;
    }

    public ExpenseField withValueDetection(ExpenseDetection valueDetection) {
        this.setValueDetection(valueDetection);
        return this;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public ExpenseField withPageNumber(Integer pageNumber) {
        this.setPageNumber(pageNumber);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getLabelDetection() != null) {
            sb.append("LabelDetection: ").append(this.getLabelDetection()).append(",");
        }
        if (this.getValueDetection() != null) {
            sb.append("ValueDetection: ").append(this.getValueDetection()).append(",");
        }
        if (this.getPageNumber() != null) {
            sb.append("PageNumber: ").append(this.getPageNumber());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExpenseField)) {
            return false;
        }
        ExpenseField other = (ExpenseField)obj;
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getLabelDetection() == null ^ this.getLabelDetection() == null) {
            return false;
        }
        if (other.getLabelDetection() != null && !other.getLabelDetection().equals(this.getLabelDetection())) {
            return false;
        }
        if (other.getValueDetection() == null ^ this.getValueDetection() == null) {
            return false;
        }
        if (other.getValueDetection() != null && !other.getValueDetection().equals(this.getValueDetection())) {
            return false;
        }
        if (other.getPageNumber() == null ^ this.getPageNumber() == null) {
            return false;
        }
        return other.getPageNumber() == null || other.getPageNumber().equals(this.getPageNumber());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getLabelDetection() == null ? 0 : this.getLabelDetection().hashCode());
        hashCode = 31 * hashCode + (this.getValueDetection() == null ? 0 : this.getValueDetection().hashCode());
        hashCode = 31 * hashCode + (this.getPageNumber() == null ? 0 : this.getPageNumber().hashCode());
        return hashCode;
    }

    public ExpenseField clone() {
        try {
            return (ExpenseField)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExpenseFieldMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

