/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.test.util;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.test.util.InputStreamUtils;
import com.amazonaws.util.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.junit.Assert;

public class SdkAsserts {
    @Deprecated
    public static void assertNotEmpty(String str) {
        Assert.assertNotNull((Object)str);
        Assert.assertTrue((str.length() > 0 ? 1 : 0) != 0);
    }

    public static void assertFileEqualsStream(File expected, InputStream actual) {
        SdkAsserts.assertFileEqualsStream(null, expected, actual);
    }

    public static void assertFileEqualsStream(String errmsg, File expected, InputStream actual) {
        try {
            FileInputStream expectedInputStream = new FileInputStream(expected);
            SdkAsserts.assertStreamEqualsStream(errmsg, expectedInputStream, actual);
        }
        catch (FileNotFoundException e) {
            Assert.fail((String)("Expected file " + expected.getAbsolutePath() + " doesn't exist: " + e.getMessage()));
        }
    }

    public static void assertStreamEqualsStream(InputStream expected, InputStream actual) {
        SdkAsserts.assertStreamEqualsStream(null, expected, actual);
    }

    public static void assertStreamEqualsStream(String errmsg, InputStream expectedInputStream, InputStream inputStream) {
        try {
            Assert.assertTrue((String)errmsg, (boolean)SdkAsserts.doesStreamEqualStream(expectedInputStream, inputStream));
        }
        catch (IOException e) {
            Assert.fail((String)("Error reading from stream: " + e.getMessage()));
        }
    }

    public static void assertFileEqualsFile(File expected, File actual) {
        if (expected == null || !expected.exists()) {
            Assert.fail((String)"Expected file doesn't exist");
        }
        if (actual == null || !actual.exists()) {
            Assert.fail((String)"Actual file doesn't exist");
        }
        long expectedFileLen = expected.length();
        long fileLen = actual.length();
        Assert.assertTrue((String)("expectedFileLen=" + expectedFileLen + ", fileLen=" + fileLen + ", expectedFile=" + expected + ", file=" + actual), (expectedFileLen == fileLen ? 1 : 0) != 0);
        try {
            SdkAsserts.assertStreamEqualsStream("expected file: " + expected + " vs. actual file: " + actual, new FileInputStream(expected), new FileInputStream(actual));
        }
        catch (Exception e) {
            Assert.fail((String)("Unable to compare files: " + e.getMessage()));
        }
    }

    public static void assertStringEqualsStream(String expected, InputStream actual) {
        try {
            ByteArrayInputStream expectedInputStream = new ByteArrayInputStream(expected.getBytes());
            Assert.assertTrue((boolean)SdkAsserts.doesStreamEqualStream(expectedInputStream, actual));
        }
        catch (IOException e) {
            Assert.fail((String)("Error reading from stream: " + e.getMessage()));
        }
    }

    public static boolean doesStreamEqualStream(InputStream expected, InputStream actual) throws IOException {
        try {
            byte[] expectedDigest = InputStreamUtils.calculateMD5Digest(expected);
            byte[] actualDigest = InputStreamUtils.calculateMD5Digest(actual);
            boolean bl = Arrays.equals(expectedDigest, actualDigest);
            return bl;
        }
        catch (NoSuchAlgorithmException nse) {
            throw new AmazonClientException(nse.getMessage(), (Throwable)nse);
        }
        finally {
            IOUtils.closeQuietly((Closeable)expected, null);
            IOUtils.closeQuietly((Closeable)actual, null);
        }
    }

    public static boolean doesFileEqualStream(File expectedFile, InputStream inputStream) throws IOException {
        FileInputStream expectedInputStream = new FileInputStream(expectedFile);
        return SdkAsserts.doesStreamEqualStream(expectedInputStream, inputStream);
    }

    public static void assertValidException(AmazonServiceException e) {
        Assert.assertNotNull((Object)e.getRequestId());
        Assert.assertTrue((e.getRequestId().trim().length() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)e.getMessage());
        Assert.assertTrue((e.getMessage().trim().length() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)e.getErrorCode());
        Assert.assertTrue((e.getErrorCode().trim().length() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)e.getServiceName());
        Assert.assertTrue((e.getServiceName().startsWith("Amazon") || e.getServiceName().startsWith("AWS") ? 1 : 0) != 0);
    }
}

