/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.taxsettings;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.taxsettings.AWSTaxSettings;
import com.amazonaws.services.taxsettings.AWSTaxSettingsClientBuilder;
import com.amazonaws.services.taxsettings.model.AWSTaxSettingsException;
import com.amazonaws.services.taxsettings.model.BatchDeleteTaxRegistrationRequest;
import com.amazonaws.services.taxsettings.model.BatchDeleteTaxRegistrationResult;
import com.amazonaws.services.taxsettings.model.BatchPutTaxRegistrationRequest;
import com.amazonaws.services.taxsettings.model.BatchPutTaxRegistrationResult;
import com.amazonaws.services.taxsettings.model.DeleteTaxRegistrationRequest;
import com.amazonaws.services.taxsettings.model.DeleteTaxRegistrationResult;
import com.amazonaws.services.taxsettings.model.GetTaxRegistrationDocumentRequest;
import com.amazonaws.services.taxsettings.model.GetTaxRegistrationDocumentResult;
import com.amazonaws.services.taxsettings.model.GetTaxRegistrationRequest;
import com.amazonaws.services.taxsettings.model.GetTaxRegistrationResult;
import com.amazonaws.services.taxsettings.model.ListTaxRegistrationsRequest;
import com.amazonaws.services.taxsettings.model.ListTaxRegistrationsResult;
import com.amazonaws.services.taxsettings.model.PutTaxRegistrationRequest;
import com.amazonaws.services.taxsettings.model.PutTaxRegistrationResult;
import com.amazonaws.services.taxsettings.model.transform.BatchDeleteTaxRegistrationRequestProtocolMarshaller;
import com.amazonaws.services.taxsettings.model.transform.BatchDeleteTaxRegistrationResultJsonUnmarshaller;
import com.amazonaws.services.taxsettings.model.transform.BatchPutTaxRegistrationRequestProtocolMarshaller;
import com.amazonaws.services.taxsettings.model.transform.BatchPutTaxRegistrationResultJsonUnmarshaller;
import com.amazonaws.services.taxsettings.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.taxsettings.model.transform.DeleteTaxRegistrationRequestProtocolMarshaller;
import com.amazonaws.services.taxsettings.model.transform.DeleteTaxRegistrationResultJsonUnmarshaller;
import com.amazonaws.services.taxsettings.model.transform.GetTaxRegistrationDocumentRequestProtocolMarshaller;
import com.amazonaws.services.taxsettings.model.transform.GetTaxRegistrationDocumentResultJsonUnmarshaller;
import com.amazonaws.services.taxsettings.model.transform.GetTaxRegistrationRequestProtocolMarshaller;
import com.amazonaws.services.taxsettings.model.transform.GetTaxRegistrationResultJsonUnmarshaller;
import com.amazonaws.services.taxsettings.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.taxsettings.model.transform.ListTaxRegistrationsRequestProtocolMarshaller;
import com.amazonaws.services.taxsettings.model.transform.ListTaxRegistrationsResultJsonUnmarshaller;
import com.amazonaws.services.taxsettings.model.transform.PutTaxRegistrationRequestProtocolMarshaller;
import com.amazonaws.services.taxsettings.model.transform.PutTaxRegistrationResultJsonUnmarshaller;
import com.amazonaws.services.taxsettings.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.taxsettings.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSTaxSettingsClient
extends AmazonWebServiceClient
implements AWSTaxSettings {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSTaxSettings.class);
    private static final String DEFAULT_SIGNING_NAME = "tax";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSTaxSettingsException.class));

    public static AWSTaxSettingsClientBuilder builder() {
        return AWSTaxSettingsClientBuilder.standard();
    }

    AWSTaxSettingsClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSTaxSettingsClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("tax.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/taxsettings/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/taxsettings/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public BatchDeleteTaxRegistrationResult batchDeleteTaxRegistration(BatchDeleteTaxRegistrationRequest request) {
        request = (BatchDeleteTaxRegistrationRequest)this.beforeClientExecution(request);
        return this.executeBatchDeleteTaxRegistration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchDeleteTaxRegistrationResult executeBatchDeleteTaxRegistration(BatchDeleteTaxRegistrationRequest batchDeleteTaxRegistrationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchDeleteTaxRegistrationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchDeleteTaxRegistrationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchDeleteTaxRegistrationRequestProtocolMarshaller(protocolFactory).marshall((BatchDeleteTaxRegistrationRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchDeleteTaxRegistrationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"TaxSettings");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchDeleteTaxRegistration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchDeleteTaxRegistrationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchDeleteTaxRegistrationResult batchDeleteTaxRegistrationResult = (BatchDeleteTaxRegistrationResult)response.getAwsResponse();
            return batchDeleteTaxRegistrationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public BatchPutTaxRegistrationResult batchPutTaxRegistration(BatchPutTaxRegistrationRequest request) {
        request = (BatchPutTaxRegistrationRequest)this.beforeClientExecution(request);
        return this.executeBatchPutTaxRegistration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchPutTaxRegistrationResult executeBatchPutTaxRegistration(BatchPutTaxRegistrationRequest batchPutTaxRegistrationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchPutTaxRegistrationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchPutTaxRegistrationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchPutTaxRegistrationRequestProtocolMarshaller(protocolFactory).marshall((BatchPutTaxRegistrationRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchPutTaxRegistrationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"TaxSettings");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchPutTaxRegistration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchPutTaxRegistrationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchPutTaxRegistrationResult batchPutTaxRegistrationResult = (BatchPutTaxRegistrationResult)response.getAwsResponse();
            return batchPutTaxRegistrationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteTaxRegistrationResult deleteTaxRegistration(DeleteTaxRegistrationRequest request) {
        request = (DeleteTaxRegistrationRequest)this.beforeClientExecution(request);
        return this.executeDeleteTaxRegistration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteTaxRegistrationResult executeDeleteTaxRegistration(DeleteTaxRegistrationRequest deleteTaxRegistrationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteTaxRegistrationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteTaxRegistrationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteTaxRegistrationRequestProtocolMarshaller(protocolFactory).marshall((DeleteTaxRegistrationRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteTaxRegistrationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"TaxSettings");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteTaxRegistration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteTaxRegistrationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteTaxRegistrationResult deleteTaxRegistrationResult = (DeleteTaxRegistrationResult)response.getAwsResponse();
            return deleteTaxRegistrationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetTaxRegistrationResult getTaxRegistration(GetTaxRegistrationRequest request) {
        request = (GetTaxRegistrationRequest)this.beforeClientExecution(request);
        return this.executeGetTaxRegistration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetTaxRegistrationResult executeGetTaxRegistration(GetTaxRegistrationRequest getTaxRegistrationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getTaxRegistrationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetTaxRegistrationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetTaxRegistrationRequestProtocolMarshaller(protocolFactory).marshall((GetTaxRegistrationRequest)super.beforeMarshalling((AmazonWebServiceRequest)getTaxRegistrationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"TaxSettings");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetTaxRegistration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetTaxRegistrationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetTaxRegistrationResult getTaxRegistrationResult = (GetTaxRegistrationResult)response.getAwsResponse();
            return getTaxRegistrationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetTaxRegistrationDocumentResult getTaxRegistrationDocument(GetTaxRegistrationDocumentRequest request) {
        request = (GetTaxRegistrationDocumentRequest)this.beforeClientExecution(request);
        return this.executeGetTaxRegistrationDocument(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetTaxRegistrationDocumentResult executeGetTaxRegistrationDocument(GetTaxRegistrationDocumentRequest getTaxRegistrationDocumentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getTaxRegistrationDocumentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetTaxRegistrationDocumentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetTaxRegistrationDocumentRequestProtocolMarshaller(protocolFactory).marshall((GetTaxRegistrationDocumentRequest)super.beforeMarshalling((AmazonWebServiceRequest)getTaxRegistrationDocumentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"TaxSettings");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetTaxRegistrationDocument");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetTaxRegistrationDocumentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetTaxRegistrationDocumentResult getTaxRegistrationDocumentResult = (GetTaxRegistrationDocumentResult)response.getAwsResponse();
            return getTaxRegistrationDocumentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTaxRegistrationsResult listTaxRegistrations(ListTaxRegistrationsRequest request) {
        request = (ListTaxRegistrationsRequest)this.beforeClientExecution(request);
        return this.executeListTaxRegistrations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTaxRegistrationsResult executeListTaxRegistrations(ListTaxRegistrationsRequest listTaxRegistrationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTaxRegistrationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTaxRegistrationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTaxRegistrationsRequestProtocolMarshaller(protocolFactory).marshall((ListTaxRegistrationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTaxRegistrationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"TaxSettings");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTaxRegistrations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTaxRegistrationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTaxRegistrationsResult listTaxRegistrationsResult = (ListTaxRegistrationsResult)response.getAwsResponse();
            return listTaxRegistrationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutTaxRegistrationResult putTaxRegistration(PutTaxRegistrationRequest request) {
        request = (PutTaxRegistrationRequest)this.beforeClientExecution(request);
        return this.executePutTaxRegistration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutTaxRegistrationResult executePutTaxRegistration(PutTaxRegistrationRequest putTaxRegistrationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putTaxRegistrationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutTaxRegistrationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutTaxRegistrationRequestProtocolMarshaller(protocolFactory).marshall((PutTaxRegistrationRequest)super.beforeMarshalling((AmazonWebServiceRequest)putTaxRegistrationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"TaxSettings");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutTaxRegistration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutTaxRegistrationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutTaxRegistrationResult putTaxRegistrationResult = (PutTaxRegistrationResult)response.getAwsResponse();
            return putTaxRegistrationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

