/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.taxsettings.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.taxsettings.model.Address;
import com.amazonaws.services.taxsettings.model.AddressRoleType;
import com.amazonaws.services.taxsettings.model.Jurisdiction;
import com.amazonaws.services.taxsettings.model.transform.AccountMetaDataMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class AccountMetaData
implements Serializable,
Cloneable,
StructuredPojo {
    private String accountName;
    private Address address;
    private Map<String, Jurisdiction> addressRoleMap;
    private String addressType;
    private String seller;

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public AccountMetaData withAccountName(String accountName) {
        this.setAccountName(accountName);
        return this;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public Address getAddress() {
        return this.address;
    }

    public AccountMetaData withAddress(Address address) {
        this.setAddress(address);
        return this;
    }

    public Map<String, Jurisdiction> getAddressRoleMap() {
        return this.addressRoleMap;
    }

    public void setAddressRoleMap(Map<String, Jurisdiction> addressRoleMap) {
        this.addressRoleMap = addressRoleMap;
    }

    public AccountMetaData withAddressRoleMap(Map<String, Jurisdiction> addressRoleMap) {
        this.setAddressRoleMap(addressRoleMap);
        return this;
    }

    public AccountMetaData addAddressRoleMapEntry(String key, Jurisdiction value) {
        if (null == this.addressRoleMap) {
            this.addressRoleMap = new HashMap<String, Jurisdiction>();
        }
        if (this.addressRoleMap.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.addressRoleMap.put(key, value);
        return this;
    }

    public AccountMetaData clearAddressRoleMapEntries() {
        this.addressRoleMap = null;
        return this;
    }

    public void setAddressType(String addressType) {
        this.addressType = addressType;
    }

    public String getAddressType() {
        return this.addressType;
    }

    public AccountMetaData withAddressType(String addressType) {
        this.setAddressType(addressType);
        return this;
    }

    public AccountMetaData withAddressType(AddressRoleType addressType) {
        this.addressType = addressType.toString();
        return this;
    }

    public void setSeller(String seller) {
        this.seller = seller;
    }

    public String getSeller() {
        return this.seller;
    }

    public AccountMetaData withSeller(String seller) {
        this.setSeller(seller);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccountName() != null) {
            sb.append("AccountName: ").append(this.getAccountName()).append(",");
        }
        if (this.getAddress() != null) {
            sb.append("Address: ").append(this.getAddress()).append(",");
        }
        if (this.getAddressRoleMap() != null) {
            sb.append("AddressRoleMap: ").append(this.getAddressRoleMap()).append(",");
        }
        if (this.getAddressType() != null) {
            sb.append("AddressType: ").append(this.getAddressType()).append(",");
        }
        if (this.getSeller() != null) {
            sb.append("Seller: ").append(this.getSeller());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountMetaData)) {
            return false;
        }
        AccountMetaData other = (AccountMetaData)obj;
        if (other.getAccountName() == null ^ this.getAccountName() == null) {
            return false;
        }
        if (other.getAccountName() != null && !other.getAccountName().equals(this.getAccountName())) {
            return false;
        }
        if (other.getAddress() == null ^ this.getAddress() == null) {
            return false;
        }
        if (other.getAddress() != null && !other.getAddress().equals(this.getAddress())) {
            return false;
        }
        if (other.getAddressRoleMap() == null ^ this.getAddressRoleMap() == null) {
            return false;
        }
        if (other.getAddressRoleMap() != null && !other.getAddressRoleMap().equals(this.getAddressRoleMap())) {
            return false;
        }
        if (other.getAddressType() == null ^ this.getAddressType() == null) {
            return false;
        }
        if (other.getAddressType() != null && !other.getAddressType().equals(this.getAddressType())) {
            return false;
        }
        if (other.getSeller() == null ^ this.getSeller() == null) {
            return false;
        }
        return other.getSeller() == null || other.getSeller().equals(this.getSeller());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccountName() == null ? 0 : this.getAccountName().hashCode());
        hashCode = 31 * hashCode + (this.getAddress() == null ? 0 : this.getAddress().hashCode());
        hashCode = 31 * hashCode + (this.getAddressRoleMap() == null ? 0 : this.getAddressRoleMap().hashCode());
        hashCode = 31 * hashCode + (this.getAddressType() == null ? 0 : this.getAddressType().hashCode());
        hashCode = 31 * hashCode + (this.getSeller() == null ? 0 : this.getSeller().hashCode());
        return hashCode;
    }

    public AccountMetaData clone() {
        try {
            return (AccountMetaData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AccountMetaDataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

