/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.services.simpleworkflow.flow.worker.DecisionId;
import com.amazonaws.services.simpleworkflow.flow.worker.DecisionState;
import com.amazonaws.services.simpleworkflow.flow.worker.DecisionStateMachine;
import com.amazonaws.services.simpleworkflow.model.HistoryEvent;
import java.util.ArrayList;
import java.util.List;

abstract class DecisionStateMachineBase
implements DecisionStateMachine {
    protected DecisionState state = DecisionState.CREATED;
    protected List<String> stateHistory = new ArrayList<String>();
    private final DecisionId id;

    public DecisionStateMachineBase(DecisionId id) {
        this.id = id;
        this.stateHistory.add(this.state.toString());
    }

    protected DecisionStateMachineBase(DecisionId id, DecisionState state) {
        this.id = id;
        this.state = state;
        this.stateHistory.add(state.toString());
    }

    @Override
    public DecisionState getState() {
        return this.state;
    }

    @Override
    public DecisionId getId() {
        return this.id;
    }

    @Override
    public boolean isDone() {
        return this.state == DecisionState.COMPLETED || this.state == DecisionState.COMPLETED_AFTER_CANCELLATION_DECISION_SENT;
    }

    @Override
    public void handleDecisionTaskStartedEvent() {
        switch (this.state) {
            case CREATED: {
                this.stateHistory.add("handleDecisionTaskStartedEvent");
                this.state = DecisionState.DECISION_SENT;
                this.stateHistory.add(this.state.toString());
            }
        }
    }

    @Override
    public void cancel(Runnable immediateCancellationCallback) {
        this.stateHistory.add("cancel");
        switch (this.state) {
            case CREATED: {
                this.state = DecisionState.COMPLETED;
                if (immediateCancellationCallback == null) break;
                immediateCancellationCallback.run();
                break;
            }
            case DECISION_SENT: {
                this.state = DecisionState.CANCELED_BEFORE_INITIATED;
                break;
            }
            case INITIATED: {
                this.state = DecisionState.CANCELED_AFTER_INITIATED;
                break;
            }
            default: {
                this.failStateTransition();
            }
        }
        this.stateHistory.add(this.state.toString());
    }

    @Override
    public void handleInitiatedEvent(HistoryEvent event) {
        this.stateHistory.add("handleInitiatedEvent");
        switch (this.state) {
            case DECISION_SENT: {
                this.state = DecisionState.INITIATED;
                break;
            }
            case CANCELED_BEFORE_INITIATED: {
                this.state = DecisionState.CANCELED_AFTER_INITIATED;
                break;
            }
            default: {
                this.failStateTransition();
            }
        }
        this.stateHistory.add(this.state.toString());
    }

    @Override
    public void handleInitiationFailedEvent(HistoryEvent event) {
        this.stateHistory.add("handleInitiationFailedEvent");
        switch (this.state) {
            case DECISION_SENT: 
            case CANCELED_BEFORE_INITIATED: {
                this.state = DecisionState.COMPLETED;
                break;
            }
            default: {
                this.failStateTransition();
            }
        }
        this.stateHistory.add(this.state.toString());
    }

    @Override
    public void handleStartedEvent(HistoryEvent event) {
        this.stateHistory.add("handleStartedEvent");
    }

    @Override
    public void handleCompletionEvent() {
        this.stateHistory.add("handleCompletionEvent");
        switch (this.state) {
            case INITIATED: 
            case CANCELED_AFTER_INITIATED: {
                this.state = DecisionState.COMPLETED;
                break;
            }
            case CANCELLATION_DECISION_SENT: {
                this.state = DecisionState.COMPLETED_AFTER_CANCELLATION_DECISION_SENT;
                break;
            }
            default: {
                this.failStateTransition();
            }
        }
        this.stateHistory.add(this.state.toString());
    }

    @Override
    public void handleCancellationInitiatedEvent() {
        this.stateHistory.add("handleCancellationInitiatedEvent");
        switch (this.state) {
            case CANCELLATION_DECISION_SENT: {
                break;
            }
            default: {
                this.failStateTransition();
            }
        }
        this.stateHistory.add(this.state.toString());
    }

    @Override
    public void handleCancellationFailureEvent(HistoryEvent event) {
        this.stateHistory.add("handleCancellationFailureEvent");
        switch (this.state) {
            case COMPLETED_AFTER_CANCELLATION_DECISION_SENT: {
                this.state = DecisionState.COMPLETED;
                break;
            }
            default: {
                this.failStateTransition();
            }
        }
        this.stateHistory.add(this.state.toString());
    }

    @Override
    public void handleCancellationEvent() {
        this.stateHistory.add("handleCancellationEvent");
        switch (this.state) {
            case CANCELLATION_DECISION_SENT: {
                this.state = DecisionState.COMPLETED;
                break;
            }
            default: {
                this.failStateTransition();
            }
        }
        this.stateHistory.add(this.state.toString());
    }

    public String toString() {
        return "DecisionStateMachineBase [id=" + this.id + ", state=" + (Object)((Object)this.state) + ", isDone()=" + this.isDone() + ", stateHistory=" + this.stateHistory + "]";
    }

    protected void failStateTransition() {
        throw new IllegalStateException("id=" + this.id + ", transitions=" + this.stateHistory);
    }
}

