/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.support.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.support.model.transform.AttachmentMarshaller;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class Attachment
implements Serializable,
Cloneable,
StructuredPojo {
    private String fileName;
    private ByteBuffer data;

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Attachment withFileName(String fileName) {
        this.setFileName(fileName);
        return this;
    }

    public void setData(ByteBuffer data) {
        this.data = data;
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public Attachment withData(ByteBuffer data) {
        this.setData(data);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFileName() != null) {
            sb.append("FileName: ").append(this.getFileName()).append(",");
        }
        if (this.getData() != null) {
            sb.append("Data: ").append(this.getData());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Attachment)) {
            return false;
        }
        Attachment other = (Attachment)obj;
        if (other.getFileName() == null ^ this.getFileName() == null) {
            return false;
        }
        if (other.getFileName() != null && !other.getFileName().equals(this.getFileName())) {
            return false;
        }
        if (other.getData() == null ^ this.getData() == null) {
            return false;
        }
        return other.getData() == null || other.getData().equals(this.getData());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFileName() == null ? 0 : this.getFileName().hashCode());
        hashCode = 31 * hashCode + (this.getData() == null ? 0 : this.getData().hashCode());
        return hashCode;
    }

    public Attachment clone() {
        try {
            return (Attachment)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AttachmentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

