/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.support.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.support.model.CaseDetails;
import com.amazonaws.services.support.model.transform.RecentCaseCommunicationsJsonMarshaller;
import com.amazonaws.util.json.SdkJsonGenerator;

public class CaseDetailsJsonMarshaller {
    private static CaseDetailsJsonMarshaller instance;

    public void marshall(CaseDetails caseDetails, SdkJsonGenerator jsonGenerator) {
        if (caseDetails == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList ccEmailAddressesList;
            jsonGenerator.writeStartObject();
            if (caseDetails.getCaseId() != null) {
                jsonGenerator.writeFieldName("caseId").writeValue(caseDetails.getCaseId());
            }
            if (caseDetails.getDisplayId() != null) {
                jsonGenerator.writeFieldName("displayId").writeValue(caseDetails.getDisplayId());
            }
            if (caseDetails.getSubject() != null) {
                jsonGenerator.writeFieldName("subject").writeValue(caseDetails.getSubject());
            }
            if (caseDetails.getStatus() != null) {
                jsonGenerator.writeFieldName("status").writeValue(caseDetails.getStatus());
            }
            if (caseDetails.getServiceCode() != null) {
                jsonGenerator.writeFieldName("serviceCode").writeValue(caseDetails.getServiceCode());
            }
            if (caseDetails.getCategoryCode() != null) {
                jsonGenerator.writeFieldName("categoryCode").writeValue(caseDetails.getCategoryCode());
            }
            if (caseDetails.getSeverityCode() != null) {
                jsonGenerator.writeFieldName("severityCode").writeValue(caseDetails.getSeverityCode());
            }
            if (caseDetails.getSubmittedBy() != null) {
                jsonGenerator.writeFieldName("submittedBy").writeValue(caseDetails.getSubmittedBy());
            }
            if (caseDetails.getTimeCreated() != null) {
                jsonGenerator.writeFieldName("timeCreated").writeValue(caseDetails.getTimeCreated());
            }
            if (caseDetails.getRecentCommunications() != null) {
                jsonGenerator.writeFieldName("recentCommunications");
                RecentCaseCommunicationsJsonMarshaller.getInstance().marshall(caseDetails.getRecentCommunications(), jsonGenerator);
            }
            if (!(ccEmailAddressesList = (SdkInternalList)caseDetails.getCcEmailAddresses()).isEmpty() || !ccEmailAddressesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("ccEmailAddresses");
                jsonGenerator.writeStartArray();
                for (String ccEmailAddressesListValue : ccEmailAddressesList) {
                    if (ccEmailAddressesListValue == null) continue;
                    jsonGenerator.writeValue(ccEmailAddressesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (caseDetails.getLanguage() != null) {
                jsonGenerator.writeFieldName("language").writeValue(caseDetails.getLanguage());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static CaseDetailsJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new CaseDetailsJsonMarshaller();
        }
        return instance;
    }
}

