/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.support.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.support.model.DescribeServicesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeServicesRequestMarshaller
implements Marshaller<Request<DescribeServicesRequest>, DescribeServicesRequest> {
    public Request<DescribeServicesRequest> marshall(DescribeServicesRequest describeServicesRequest) {
        if (describeServicesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeServicesRequest, "AWSSupport");
        request.addHeader("X-Amz-Target", "AWSSupport_20130415.DescribeServices");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList serviceCodeListList = (SdkInternalList)describeServicesRequest.getServiceCodeList();
            if (!serviceCodeListList.isEmpty() || !serviceCodeListList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("serviceCodeList");
                jsonGenerator.writeStartArray();
                for (String serviceCodeListListValue : serviceCodeListList) {
                    if (serviceCodeListListValue == null) continue;
                    jsonGenerator.writeValue(serviceCodeListListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (describeServicesRequest.getLanguage() != null) {
                jsonGenerator.writeFieldName("language").writeValue(describeServicesRequest.getLanguage());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

