/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.support.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.support.model.Category;
import com.amazonaws.services.support.model.Service;
import com.amazonaws.services.support.model.transform.CategoryJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class ServiceJsonMarshaller {
    private static ServiceJsonMarshaller instance;

    public void marshall(Service service, JSONWriter jsonWriter) {
        if (service == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList categoriesList;
            jsonWriter.object();
            if (service.getCode() != null) {
                jsonWriter.key("code").value((Object)service.getCode());
            }
            if (service.getName() != null) {
                jsonWriter.key("name").value((Object)service.getName());
            }
            if (!(categoriesList = (SdkInternalList)service.getCategories()).isEmpty() || !categoriesList.isAutoConstruct()) {
                jsonWriter.key("categories");
                jsonWriter.array();
                for (Category categoriesListValue : categoriesList) {
                    if (categoriesListValue == null) continue;
                    CategoryJsonMarshaller.getInstance().marshall(categoriesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ServiceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ServiceJsonMarshaller();
        }
        return instance;
    }
}

