/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RemoveTagsFromResourceRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String resourceARN;
    private ListWithAutoConstructFlag<String> tagKeys;

    public String getResourceARN() {
        return this.resourceARN;
    }

    public void setResourceARN(String resourceARN) {
        this.resourceARN = resourceARN;
    }

    public RemoveTagsFromResourceRequest withResourceARN(String resourceARN) {
        this.resourceARN = resourceARN;
        return this;
    }

    public List<String> getTagKeys() {
        if (this.tagKeys == null) {
            this.tagKeys = new ListWithAutoConstructFlag();
            this.tagKeys.setAutoConstruct(true);
        }
        return this.tagKeys;
    }

    public void setTagKeys(Collection<String> tagKeys) {
        if (tagKeys == null) {
            this.tagKeys = null;
            return;
        }
        ListWithAutoConstructFlag tagKeysCopy = new ListWithAutoConstructFlag(tagKeys.size());
        tagKeysCopy.addAll(tagKeys);
        this.tagKeys = tagKeysCopy;
    }

    public RemoveTagsFromResourceRequest withTagKeys(String ... tagKeys) {
        if (this.getTagKeys() == null) {
            this.setTagKeys(new ArrayList<String>(tagKeys.length));
        }
        for (String value : tagKeys) {
            this.getTagKeys().add(value);
        }
        return this;
    }

    public RemoveTagsFromResourceRequest withTagKeys(Collection<String> tagKeys) {
        if (tagKeys == null) {
            this.tagKeys = null;
        } else {
            ListWithAutoConstructFlag tagKeysCopy = new ListWithAutoConstructFlag(tagKeys.size());
            tagKeysCopy.addAll(tagKeys);
            this.tagKeys = tagKeysCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceARN() != null) {
            sb.append("ResourceARN: " + this.getResourceARN() + ",");
        }
        if (this.getTagKeys() != null) {
            sb.append("TagKeys: " + this.getTagKeys());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceARN() == null ? 0 : this.getResourceARN().hashCode());
        hashCode = 31 * hashCode + (this.getTagKeys() == null ? 0 : this.getTagKeys().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveTagsFromResourceRequest)) {
            return false;
        }
        RemoveTagsFromResourceRequest other = (RemoveTagsFromResourceRequest)obj;
        if (other.getResourceARN() == null ^ this.getResourceARN() == null) {
            return false;
        }
        if (other.getResourceARN() != null && !other.getResourceARN().equals(this.getResourceARN())) {
            return false;
        }
        if (other.getTagKeys() == null ^ this.getTagKeys() == null) {
            return false;
        }
        return other.getTagKeys() == null || other.getTagKeys().equals(this.getTagKeys());
    }

    public RemoveTagsFromResourceRequest clone() {
        return (RemoveTagsFromResourceRequest)super.clone();
    }
}

