/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.stepfunctions.model.EncryptionConfiguration;
import com.amazonaws.services.stepfunctions.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateActivityRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private List<Tag> tags;
    private EncryptionConfiguration encryptionConfiguration;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateActivityRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateActivityRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateActivityRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setEncryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
        this.encryptionConfiguration = encryptionConfiguration;
    }

    public EncryptionConfiguration getEncryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public CreateActivityRequest withEncryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
        this.setEncryptionConfiguration(encryptionConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getEncryptionConfiguration() != null) {
            sb.append("EncryptionConfiguration: ").append(this.getEncryptionConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateActivityRequest)) {
            return false;
        }
        CreateActivityRequest other = (CreateActivityRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getEncryptionConfiguration() == null ^ this.getEncryptionConfiguration() == null) {
            return false;
        }
        return other.getEncryptionConfiguration() == null || other.getEncryptionConfiguration().equals(this.getEncryptionConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getEncryptionConfiguration() == null ? 0 : this.getEncryptionConfiguration().hashCode());
        return hashCode;
    }

    public CreateActivityRequest clone() {
        return (CreateActivityRequest)super.clone();
    }
}

