/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions.builder;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.stepfunctions.builder.internal.Buildable;
import com.amazonaws.services.stepfunctions.builder.internal.DateModule;
import com.amazonaws.services.stepfunctions.builder.internal.validation.StateMachineValidator;
import com.amazonaws.services.stepfunctions.builder.states.State;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class StateMachine {
    private static final ObjectMapper MAPPER = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).registerModule((Module)DateModule.INSTANCE);
    @JsonProperty(value="Comment")
    private final String comment;
    @JsonProperty(value="StartAt")
    private final String startAt;
    @JsonProperty(value="TimeoutSeconds")
    private final Integer timeoutSeconds;
    @JsonProperty(value="States")
    private final Map<String, State> states;
    @JsonProperty(value="Version")
    private final String version;

    private StateMachine(Builder builder) {
        this.comment = builder.comment;
        this.startAt = builder.startAt;
        this.timeoutSeconds = builder.timeoutSeconds;
        this.states = Buildable.Utils.build(builder.states);
        this.version = builder.version;
    }

    public String getComment() {
        return this.comment;
    }

    public String getStartAt() {
        return this.startAt;
    }

    public Integer getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public Map<String, State> getStates() {
        return this.states;
    }

    public String getVersion() {
        return this.version;
    }

    public String toJson() {
        try {
            return MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new SdkClientException("Could not serialize state machine.", (Throwable)e);
        }
    }

    public String toPrettyJson() {
        try {
            return MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new SdkClientException("Could not serialize state machine.", (Throwable)e);
        }
    }

    public static Builder fromJson(String json) {
        try {
            return (Builder)MAPPER.readValue(json, Builder.class);
        }
        catch (IOException e) {
            throw new SdkClientException(String.format("Could not deserialize state machine.\n%s", json), (Throwable)e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @JsonProperty(value="Comment")
        private String comment;
        @JsonProperty(value="StartAt")
        private String startAt;
        @JsonProperty(value="TimeoutSeconds")
        private Integer timeoutSeconds;
        @JsonProperty(value="States")
        private final Map<String, State.Builder> states = new LinkedHashMap<String, State.Builder>();
        @JsonProperty(value="Version")
        private String version;

        private Builder() {
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder startAt(String startAt) {
            this.startAt = startAt;
            return this;
        }

        public Builder timeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public Builder state(String stateName, State.Builder stateBuilder) {
            this.states.put(stateName, stateBuilder);
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public StateMachine build() {
            return new StateMachineValidator(new StateMachine(this)).validate();
        }
    }
}

