/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocumentMetadataHistory" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListDocumentMetadataHistoryResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The name of the change template.
     * </p>
     */
    private String name;
    /**
     * <p>
     * The version of the change template.
     * </p>
     */
    private String documentVersion;
    /**
     * <p>
     * The user ID of the person in the organization who requested the review of the change template.
     * </p>
     */
    private String author;
    /**
     * <p>
     * Information about the response to the change template approval request.
     * </p>
     */
    private DocumentMetadataResponseInfo metadata;
    /**
     * <p>
     * The maximum number of items to return for this call. The call also returns a token that you can specify in a
     * subsequent call to get the next set of results.
     * </p>
     */
    private String nextToken;

    /**
     * <p>
     * The name of the change template.
     * </p>
     * 
     * @param name
     *        The name of the change template.
     */

    public void setName(String name) {
        this.name = name;
    }

    /**
     * <p>
     * The name of the change template.
     * </p>
     * 
     * @return The name of the change template.
     */

    public String getName() {
        return this.name;
    }

    /**
     * <p>
     * The name of the change template.
     * </p>
     * 
     * @param name
     *        The name of the change template.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListDocumentMetadataHistoryResult withName(String name) {
        setName(name);
        return this;
    }

    /**
     * <p>
     * The version of the change template.
     * </p>
     * 
     * @param documentVersion
     *        The version of the change template.
     */

    public void setDocumentVersion(String documentVersion) {
        this.documentVersion = documentVersion;
    }

    /**
     * <p>
     * The version of the change template.
     * </p>
     * 
     * @return The version of the change template.
     */

    public String getDocumentVersion() {
        return this.documentVersion;
    }

    /**
     * <p>
     * The version of the change template.
     * </p>
     * 
     * @param documentVersion
     *        The version of the change template.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListDocumentMetadataHistoryResult withDocumentVersion(String documentVersion) {
        setDocumentVersion(documentVersion);
        return this;
    }

    /**
     * <p>
     * The user ID of the person in the organization who requested the review of the change template.
     * </p>
     * 
     * @param author
     *        The user ID of the person in the organization who requested the review of the change template.
     */

    public void setAuthor(String author) {
        this.author = author;
    }

    /**
     * <p>
     * The user ID of the person in the organization who requested the review of the change template.
     * </p>
     * 
     * @return The user ID of the person in the organization who requested the review of the change template.
     */

    public String getAuthor() {
        return this.author;
    }

    /**
     * <p>
     * The user ID of the person in the organization who requested the review of the change template.
     * </p>
     * 
     * @param author
     *        The user ID of the person in the organization who requested the review of the change template.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListDocumentMetadataHistoryResult withAuthor(String author) {
        setAuthor(author);
        return this;
    }

    /**
     * <p>
     * Information about the response to the change template approval request.
     * </p>
     * 
     * @param metadata
     *        Information about the response to the change template approval request.
     */

    public void setMetadata(DocumentMetadataResponseInfo metadata) {
        this.metadata = metadata;
    }

    /**
     * <p>
     * Information about the response to the change template approval request.
     * </p>
     * 
     * @return Information about the response to the change template approval request.
     */

    public DocumentMetadataResponseInfo getMetadata() {
        return this.metadata;
    }

    /**
     * <p>
     * Information about the response to the change template approval request.
     * </p>
     * 
     * @param metadata
     *        Information about the response to the change template approval request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListDocumentMetadataHistoryResult withMetadata(DocumentMetadataResponseInfo metadata) {
        setMetadata(metadata);
        return this;
    }

    /**
     * <p>
     * The maximum number of items to return for this call. The call also returns a token that you can specify in a
     * subsequent call to get the next set of results.
     * </p>
     * 
     * @param nextToken
     *        The maximum number of items to return for this call. The call also returns a token that you can specify in
     *        a subsequent call to get the next set of results.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * The maximum number of items to return for this call. The call also returns a token that you can specify in a
     * subsequent call to get the next set of results.
     * </p>
     * 
     * @return The maximum number of items to return for this call. The call also returns a token that you can specify
     *         in a subsequent call to get the next set of results.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * The maximum number of items to return for this call. The call also returns a token that you can specify in a
     * subsequent call to get the next set of results.
     * </p>
     * 
     * @param nextToken
     *        The maximum number of items to return for this call. The call also returns a token that you can specify in
     *        a subsequent call to get the next set of results.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListDocumentMetadataHistoryResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getName() != null)
            sb.append("Name: ").append(getName()).append(",");
        if (getDocumentVersion() != null)
            sb.append("DocumentVersion: ").append(getDocumentVersion()).append(",");
        if (getAuthor() != null)
            sb.append("Author: ").append(getAuthor()).append(",");
        if (getMetadata() != null)
            sb.append("Metadata: ").append(getMetadata()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListDocumentMetadataHistoryResult == false)
            return false;
        ListDocumentMetadataHistoryResult other = (ListDocumentMetadataHistoryResult) obj;
        if (other.getName() == null ^ this.getName() == null)
            return false;
        if (other.getName() != null && other.getName().equals(this.getName()) == false)
            return false;
        if (other.getDocumentVersion() == null ^ this.getDocumentVersion() == null)
            return false;
        if (other.getDocumentVersion() != null && other.getDocumentVersion().equals(this.getDocumentVersion()) == false)
            return false;
        if (other.getAuthor() == null ^ this.getAuthor() == null)
            return false;
        if (other.getAuthor() != null && other.getAuthor().equals(this.getAuthor()) == false)
            return false;
        if (other.getMetadata() == null ^ this.getMetadata() == null)
            return false;
        if (other.getMetadata() != null && other.getMetadata().equals(this.getMetadata()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getName() == null) ? 0 : getName().hashCode());
        hashCode = prime * hashCode + ((getDocumentVersion() == null) ? 0 : getDocumentVersion().hashCode());
        hashCode = prime * hashCode + ((getAuthor() == null) ? 0 : getAuthor().hashCode());
        hashCode = prime * hashCode + ((getMetadata() == null) ? 0 : getMetadata().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public ListDocumentMetadataHistoryResult clone() {
        try {
            return (ListDocumentMetadataHistoryResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
