/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.handlers.AbstractRequestHandler;
import com.amazonaws.util.ReflectionMethodInvoker;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class QueueUrlHandler
extends AbstractRequestHandler {
    private final Map<Class<? extends AmazonWebServiceRequest>, ReflectionMethodInvoker<AmazonWebServiceRequest, String>> reflectionMethodInvokers = new ConcurrentHashMap<Class<? extends AmazonWebServiceRequest>, ReflectionMethodInvoker<AmazonWebServiceRequest, String>>();

    public void beforeRequest(Request<?> request) {
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        String retrieveQueueUrl = this.retrieveQueueUrl(originalRequest);
        try {
            if (retrieveQueueUrl == null) {
                return;
            }
            URI uri = new URI(retrieveQueueUrl);
            request.setResourcePath(uri.getPath());
            if (uri.getHost() != null) {
                URI uriWithoutPath = new URI(uri.toString().replace(uri.getPath(), ""));
                QueueUrlHandler.appendUserAgent(request, uriWithoutPath);
                request.setEndpoint(uriWithoutPath);
            }
        }
        catch (URISyntaxException e) {
            throw new AmazonClientException("Unable to parse SQS queue URL '" + retrieveQueueUrl + "'", (Throwable)e);
        }
    }

    private static void appendUserAgent(Request<?> request, URI uriWithoutPath) {
        if (!uriWithoutPath.equals(request.getEndpoint())) {
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("md/redirect");
        }
    }

    public String retrieveQueueUrl(AmazonWebServiceRequest request) {
        ReflectionMethodInvoker getter = this.reflectionMethodInvokers.get(request.getClass());
        if (getter == null) {
            getter = new ReflectionMethodInvoker(request.getClass(), String.class, "getQueueUrl", new Class[0]);
            this.reflectionMethodInvokers.put(request.getClass(), (ReflectionMethodInvoker<AmazonWebServiceRequest, String>)getter);
        }
        try {
            return (String)getter.invoke((Object)request, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }
}

