/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.snowdevicemanagement.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.snowdevicemanagement.model.CpuOptions;
import com.amazonaws.services.snowdevicemanagement.model.InstanceBlockDeviceMapping;
import com.amazonaws.services.snowdevicemanagement.model.InstanceState;
import com.amazonaws.services.snowdevicemanagement.model.SecurityGroupIdentifier;
import com.amazonaws.services.snowdevicemanagement.model.transform.InstanceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Instance
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer amiLaunchIndex;
    private List<InstanceBlockDeviceMapping> blockDeviceMappings;
    private CpuOptions cpuOptions;
    private Date createdAt;
    private String imageId;
    private String instanceId;
    private String instanceType;
    private String privateIpAddress;
    private String publicIpAddress;
    private String rootDeviceName;
    private List<SecurityGroupIdentifier> securityGroups;
    private InstanceState state;
    private Date updatedAt;

    public void setAmiLaunchIndex(Integer amiLaunchIndex) {
        this.amiLaunchIndex = amiLaunchIndex;
    }

    public Integer getAmiLaunchIndex() {
        return this.amiLaunchIndex;
    }

    public Instance withAmiLaunchIndex(Integer amiLaunchIndex) {
        this.setAmiLaunchIndex(amiLaunchIndex);
        return this;
    }

    public List<InstanceBlockDeviceMapping> getBlockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public void setBlockDeviceMappings(Collection<InstanceBlockDeviceMapping> blockDeviceMappings) {
        if (blockDeviceMappings == null) {
            this.blockDeviceMappings = null;
            return;
        }
        this.blockDeviceMappings = new ArrayList<InstanceBlockDeviceMapping>(blockDeviceMappings);
    }

    public Instance withBlockDeviceMappings(InstanceBlockDeviceMapping ... blockDeviceMappings) {
        if (this.blockDeviceMappings == null) {
            this.setBlockDeviceMappings(new ArrayList<InstanceBlockDeviceMapping>(blockDeviceMappings.length));
        }
        for (InstanceBlockDeviceMapping ele : blockDeviceMappings) {
            this.blockDeviceMappings.add(ele);
        }
        return this;
    }

    public Instance withBlockDeviceMappings(Collection<InstanceBlockDeviceMapping> blockDeviceMappings) {
        this.setBlockDeviceMappings(blockDeviceMappings);
        return this;
    }

    public void setCpuOptions(CpuOptions cpuOptions) {
        this.cpuOptions = cpuOptions;
    }

    public CpuOptions getCpuOptions() {
        return this.cpuOptions;
    }

    public Instance withCpuOptions(CpuOptions cpuOptions) {
        this.setCpuOptions(cpuOptions);
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Instance withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public String getImageId() {
        return this.imageId;
    }

    public Instance withImageId(String imageId) {
        this.setImageId(imageId);
        return this;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public Instance withInstanceId(String instanceId) {
        this.setInstanceId(instanceId);
        return this;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public Instance withInstanceType(String instanceType) {
        this.setInstanceType(instanceType);
        return this;
    }

    public void setPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
    }

    public String getPrivateIpAddress() {
        return this.privateIpAddress;
    }

    public Instance withPrivateIpAddress(String privateIpAddress) {
        this.setPrivateIpAddress(privateIpAddress);
        return this;
    }

    public void setPublicIpAddress(String publicIpAddress) {
        this.publicIpAddress = publicIpAddress;
    }

    public String getPublicIpAddress() {
        return this.publicIpAddress;
    }

    public Instance withPublicIpAddress(String publicIpAddress) {
        this.setPublicIpAddress(publicIpAddress);
        return this;
    }

    public void setRootDeviceName(String rootDeviceName) {
        this.rootDeviceName = rootDeviceName;
    }

    public String getRootDeviceName() {
        return this.rootDeviceName;
    }

    public Instance withRootDeviceName(String rootDeviceName) {
        this.setRootDeviceName(rootDeviceName);
        return this;
    }

    public List<SecurityGroupIdentifier> getSecurityGroups() {
        return this.securityGroups;
    }

    public void setSecurityGroups(Collection<SecurityGroupIdentifier> securityGroups) {
        if (securityGroups == null) {
            this.securityGroups = null;
            return;
        }
        this.securityGroups = new ArrayList<SecurityGroupIdentifier>(securityGroups);
    }

    public Instance withSecurityGroups(SecurityGroupIdentifier ... securityGroups) {
        if (this.securityGroups == null) {
            this.setSecurityGroups(new ArrayList<SecurityGroupIdentifier>(securityGroups.length));
        }
        for (SecurityGroupIdentifier ele : securityGroups) {
            this.securityGroups.add(ele);
        }
        return this;
    }

    public Instance withSecurityGroups(Collection<SecurityGroupIdentifier> securityGroups) {
        this.setSecurityGroups(securityGroups);
        return this;
    }

    public void setState(InstanceState state) {
        this.state = state;
    }

    public InstanceState getState() {
        return this.state;
    }

    public Instance withState(InstanceState state) {
        this.setState(state);
        return this;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public Instance withUpdatedAt(Date updatedAt) {
        this.setUpdatedAt(updatedAt);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAmiLaunchIndex() != null) {
            sb.append("AmiLaunchIndex: ").append(this.getAmiLaunchIndex()).append(",");
        }
        if (this.getBlockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: ").append(this.getBlockDeviceMappings()).append(",");
        }
        if (this.getCpuOptions() != null) {
            sb.append("CpuOptions: ").append(this.getCpuOptions()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getImageId() != null) {
            sb.append("ImageId: ").append(this.getImageId()).append(",");
        }
        if (this.getInstanceId() != null) {
            sb.append("InstanceId: ").append(this.getInstanceId()).append(",");
        }
        if (this.getInstanceType() != null) {
            sb.append("InstanceType: ").append(this.getInstanceType()).append(",");
        }
        if (this.getPrivateIpAddress() != null) {
            sb.append("PrivateIpAddress: ").append(this.getPrivateIpAddress()).append(",");
        }
        if (this.getPublicIpAddress() != null) {
            sb.append("PublicIpAddress: ").append(this.getPublicIpAddress()).append(",");
        }
        if (this.getRootDeviceName() != null) {
            sb.append("RootDeviceName: ").append(this.getRootDeviceName()).append(",");
        }
        if (this.getSecurityGroups() != null) {
            sb.append("SecurityGroups: ").append(this.getSecurityGroups()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getUpdatedAt() != null) {
            sb.append("UpdatedAt: ").append(this.getUpdatedAt());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Instance)) {
            return false;
        }
        Instance other = (Instance)obj;
        if (other.getAmiLaunchIndex() == null ^ this.getAmiLaunchIndex() == null) {
            return false;
        }
        if (other.getAmiLaunchIndex() != null && !other.getAmiLaunchIndex().equals(this.getAmiLaunchIndex())) {
            return false;
        }
        if (other.getBlockDeviceMappings() == null ^ this.getBlockDeviceMappings() == null) {
            return false;
        }
        if (other.getBlockDeviceMappings() != null && !other.getBlockDeviceMappings().equals(this.getBlockDeviceMappings())) {
            return false;
        }
        if (other.getCpuOptions() == null ^ this.getCpuOptions() == null) {
            return false;
        }
        if (other.getCpuOptions() != null && !other.getCpuOptions().equals(this.getCpuOptions())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getImageId() == null ^ this.getImageId() == null) {
            return false;
        }
        if (other.getImageId() != null && !other.getImageId().equals(this.getImageId())) {
            return false;
        }
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getInstanceType() == null ^ this.getInstanceType() == null) {
            return false;
        }
        if (other.getInstanceType() != null && !other.getInstanceType().equals(this.getInstanceType())) {
            return false;
        }
        if (other.getPrivateIpAddress() == null ^ this.getPrivateIpAddress() == null) {
            return false;
        }
        if (other.getPrivateIpAddress() != null && !other.getPrivateIpAddress().equals(this.getPrivateIpAddress())) {
            return false;
        }
        if (other.getPublicIpAddress() == null ^ this.getPublicIpAddress() == null) {
            return false;
        }
        if (other.getPublicIpAddress() != null && !other.getPublicIpAddress().equals(this.getPublicIpAddress())) {
            return false;
        }
        if (other.getRootDeviceName() == null ^ this.getRootDeviceName() == null) {
            return false;
        }
        if (other.getRootDeviceName() != null && !other.getRootDeviceName().equals(this.getRootDeviceName())) {
            return false;
        }
        if (other.getSecurityGroups() == null ^ this.getSecurityGroups() == null) {
            return false;
        }
        if (other.getSecurityGroups() != null && !other.getSecurityGroups().equals(this.getSecurityGroups())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getUpdatedAt() == null ^ this.getUpdatedAt() == null) {
            return false;
        }
        return other.getUpdatedAt() == null || other.getUpdatedAt().equals(this.getUpdatedAt());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAmiLaunchIndex() == null ? 0 : this.getAmiLaunchIndex().hashCode());
        hashCode = 31 * hashCode + (this.getBlockDeviceMappings() == null ? 0 : this.getBlockDeviceMappings().hashCode());
        hashCode = 31 * hashCode + (this.getCpuOptions() == null ? 0 : this.getCpuOptions().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getImageId() == null ? 0 : this.getImageId().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceType() == null ? 0 : this.getInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateIpAddress() == null ? 0 : this.getPrivateIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.getPublicIpAddress() == null ? 0 : this.getPublicIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.getRootDeviceName() == null ? 0 : this.getRootDeviceName().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroups() == null ? 0 : this.getSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getUpdatedAt() == null ? 0 : this.getUpdatedAt().hashCode());
        return hashCode;
    }

    public Instance clone() {
        try {
            return (Instance)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

