/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.snowball.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.snowball.model.DependentService;
import com.amazonaws.services.snowball.model.ServiceName;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListServiceVersionsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String serviceName;
    private List<DependentService> dependentServices;
    private Integer maxResults;
    private String nextToken;

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public ListServiceVersionsRequest withServiceName(String serviceName) {
        this.setServiceName(serviceName);
        return this;
    }

    public ListServiceVersionsRequest withServiceName(ServiceName serviceName) {
        this.serviceName = serviceName.toString();
        return this;
    }

    public List<DependentService> getDependentServices() {
        return this.dependentServices;
    }

    public void setDependentServices(Collection<DependentService> dependentServices) {
        if (dependentServices == null) {
            this.dependentServices = null;
            return;
        }
        this.dependentServices = new ArrayList<DependentService>(dependentServices);
    }

    public ListServiceVersionsRequest withDependentServices(DependentService ... dependentServices) {
        if (this.dependentServices == null) {
            this.setDependentServices(new ArrayList<DependentService>(dependentServices.length));
        }
        for (DependentService ele : dependentServices) {
            this.dependentServices.add(ele);
        }
        return this;
    }

    public ListServiceVersionsRequest withDependentServices(Collection<DependentService> dependentServices) {
        this.setDependentServices(dependentServices);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public ListServiceVersionsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListServiceVersionsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getServiceName() != null) {
            sb.append("ServiceName: ").append(this.getServiceName()).append(",");
        }
        if (this.getDependentServices() != null) {
            sb.append("DependentServices: ").append(this.getDependentServices()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceVersionsRequest)) {
            return false;
        }
        ListServiceVersionsRequest other = (ListServiceVersionsRequest)obj;
        if (other.getServiceName() == null ^ this.getServiceName() == null) {
            return false;
        }
        if (other.getServiceName() != null && !other.getServiceName().equals(this.getServiceName())) {
            return false;
        }
        if (other.getDependentServices() == null ^ this.getDependentServices() == null) {
            return false;
        }
        if (other.getDependentServices() != null && !other.getDependentServices().equals(this.getDependentServices())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getServiceName() == null ? 0 : this.getServiceName().hashCode());
        hashCode = 31 * hashCode + (this.getDependentServices() == null ? 0 : this.getDependentServices().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListServiceVersionsRequest clone() {
        return (ListServiceVersionsRequest)super.clone();
    }
}

