/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.snowball.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.snowball.model.DependentService;
import com.amazonaws.services.snowball.model.ServiceName;
import com.amazonaws.services.snowball.model.ServiceVersion;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListServiceVersionsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<ServiceVersion> serviceVersions;
    private String serviceName;
    private List<DependentService> dependentServices;
    private String nextToken;

    public List<ServiceVersion> getServiceVersions() {
        return this.serviceVersions;
    }

    public void setServiceVersions(Collection<ServiceVersion> serviceVersions) {
        if (serviceVersions == null) {
            this.serviceVersions = null;
            return;
        }
        this.serviceVersions = new ArrayList<ServiceVersion>(serviceVersions);
    }

    public ListServiceVersionsResult withServiceVersions(ServiceVersion ... serviceVersions) {
        if (this.serviceVersions == null) {
            this.setServiceVersions(new ArrayList<ServiceVersion>(serviceVersions.length));
        }
        for (ServiceVersion ele : serviceVersions) {
            this.serviceVersions.add(ele);
        }
        return this;
    }

    public ListServiceVersionsResult withServiceVersions(Collection<ServiceVersion> serviceVersions) {
        this.setServiceVersions(serviceVersions);
        return this;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public ListServiceVersionsResult withServiceName(String serviceName) {
        this.setServiceName(serviceName);
        return this;
    }

    public ListServiceVersionsResult withServiceName(ServiceName serviceName) {
        this.serviceName = serviceName.toString();
        return this;
    }

    public List<DependentService> getDependentServices() {
        return this.dependentServices;
    }

    public void setDependentServices(Collection<DependentService> dependentServices) {
        if (dependentServices == null) {
            this.dependentServices = null;
            return;
        }
        this.dependentServices = new ArrayList<DependentService>(dependentServices);
    }

    public ListServiceVersionsResult withDependentServices(DependentService ... dependentServices) {
        if (this.dependentServices == null) {
            this.setDependentServices(new ArrayList<DependentService>(dependentServices.length));
        }
        for (DependentService ele : dependentServices) {
            this.dependentServices.add(ele);
        }
        return this;
    }

    public ListServiceVersionsResult withDependentServices(Collection<DependentService> dependentServices) {
        this.setDependentServices(dependentServices);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListServiceVersionsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getServiceVersions() != null) {
            sb.append("ServiceVersions: ").append(this.getServiceVersions()).append(",");
        }
        if (this.getServiceName() != null) {
            sb.append("ServiceName: ").append(this.getServiceName()).append(",");
        }
        if (this.getDependentServices() != null) {
            sb.append("DependentServices: ").append(this.getDependentServices()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceVersionsResult)) {
            return false;
        }
        ListServiceVersionsResult other = (ListServiceVersionsResult)obj;
        if (other.getServiceVersions() == null ^ this.getServiceVersions() == null) {
            return false;
        }
        if (other.getServiceVersions() != null && !other.getServiceVersions().equals(this.getServiceVersions())) {
            return false;
        }
        if (other.getServiceName() == null ^ this.getServiceName() == null) {
            return false;
        }
        if (other.getServiceName() != null && !other.getServiceName().equals(this.getServiceName())) {
            return false;
        }
        if (other.getDependentServices() == null ^ this.getDependentServices() == null) {
            return false;
        }
        if (other.getDependentServices() != null && !other.getDependentServices().equals(this.getDependentServices())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getServiceVersions() == null ? 0 : this.getServiceVersions().hashCode());
        hashCode = 31 * hashCode + (this.getServiceName() == null ? 0 : this.getServiceName().hashCode());
        hashCode = 31 * hashCode + (this.getDependentServices() == null ? 0 : this.getDependentServices().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListServiceVersionsResult clone() {
        try {
            return (ListServiceVersionsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

