/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.snowball.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.snowball.model.EKSOnDeviceServiceConfiguration;

@SdkInternalApi
public class EKSOnDeviceServiceConfigurationMarshaller {
    private static final MarshallingInfo<String> KUBERNETESVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KubernetesVersion").build();
    private static final MarshallingInfo<String> EKSANYWHEREVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EKSAnywhereVersion").build();
    private static final EKSOnDeviceServiceConfigurationMarshaller instance = new EKSOnDeviceServiceConfigurationMarshaller();

    public static EKSOnDeviceServiceConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(EKSOnDeviceServiceConfiguration eKSOnDeviceServiceConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (eKSOnDeviceServiceConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)eKSOnDeviceServiceConfiguration.getKubernetesVersion(), KUBERNETESVERSION_BINDING);
            protocolMarshaller.marshall((Object)eKSOnDeviceServiceConfiguration.getEKSAnywhereVersion(), EKSANYWHEREVERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

