/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.snowball;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.snowball.AmazonSnowball;
import com.amazonaws.services.snowball.AmazonSnowballClientBuilder;
import com.amazonaws.services.snowball.model.AmazonSnowballException;
import com.amazonaws.services.snowball.model.CancelClusterRequest;
import com.amazonaws.services.snowball.model.CancelClusterResult;
import com.amazonaws.services.snowball.model.CancelJobRequest;
import com.amazonaws.services.snowball.model.CancelJobResult;
import com.amazonaws.services.snowball.model.CreateAddressRequest;
import com.amazonaws.services.snowball.model.CreateAddressResult;
import com.amazonaws.services.snowball.model.CreateClusterRequest;
import com.amazonaws.services.snowball.model.CreateClusterResult;
import com.amazonaws.services.snowball.model.CreateJobRequest;
import com.amazonaws.services.snowball.model.CreateJobResult;
import com.amazonaws.services.snowball.model.CreateReturnShippingLabelRequest;
import com.amazonaws.services.snowball.model.CreateReturnShippingLabelResult;
import com.amazonaws.services.snowball.model.DescribeAddressRequest;
import com.amazonaws.services.snowball.model.DescribeAddressResult;
import com.amazonaws.services.snowball.model.DescribeAddressesRequest;
import com.amazonaws.services.snowball.model.DescribeAddressesResult;
import com.amazonaws.services.snowball.model.DescribeClusterRequest;
import com.amazonaws.services.snowball.model.DescribeClusterResult;
import com.amazonaws.services.snowball.model.DescribeJobRequest;
import com.amazonaws.services.snowball.model.DescribeJobResult;
import com.amazonaws.services.snowball.model.DescribeReturnShippingLabelRequest;
import com.amazonaws.services.snowball.model.DescribeReturnShippingLabelResult;
import com.amazonaws.services.snowball.model.GetJobManifestRequest;
import com.amazonaws.services.snowball.model.GetJobManifestResult;
import com.amazonaws.services.snowball.model.GetJobUnlockCodeRequest;
import com.amazonaws.services.snowball.model.GetJobUnlockCodeResult;
import com.amazonaws.services.snowball.model.GetSnowballUsageRequest;
import com.amazonaws.services.snowball.model.GetSnowballUsageResult;
import com.amazonaws.services.snowball.model.GetSoftwareUpdatesRequest;
import com.amazonaws.services.snowball.model.GetSoftwareUpdatesResult;
import com.amazonaws.services.snowball.model.ListClusterJobsRequest;
import com.amazonaws.services.snowball.model.ListClusterJobsResult;
import com.amazonaws.services.snowball.model.ListClustersRequest;
import com.amazonaws.services.snowball.model.ListClustersResult;
import com.amazonaws.services.snowball.model.ListCompatibleImagesRequest;
import com.amazonaws.services.snowball.model.ListCompatibleImagesResult;
import com.amazonaws.services.snowball.model.ListJobsRequest;
import com.amazonaws.services.snowball.model.ListJobsResult;
import com.amazonaws.services.snowball.model.UpdateClusterRequest;
import com.amazonaws.services.snowball.model.UpdateClusterResult;
import com.amazonaws.services.snowball.model.UpdateJobRequest;
import com.amazonaws.services.snowball.model.UpdateJobResult;
import com.amazonaws.services.snowball.model.UpdateJobShipmentStateRequest;
import com.amazonaws.services.snowball.model.UpdateJobShipmentStateResult;
import com.amazonaws.services.snowball.model.transform.CancelClusterRequestProtocolMarshaller;
import com.amazonaws.services.snowball.model.transform.CancelClusterResultJsonUnmarshaller;
import com.amazonaws.services.snowball.model.transform.CancelJobRequestProtocolMarshaller;
import com.amazonaws.services.snowball.model.transform.CancelJobResultJsonUnmarshaller;
import com.amazonaws.services.snowball.model.transform.ClusterLimitExceededExceptionUnmarshaller;
import com.amazonaws.services.snowball.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.snowball.model.transform.CreateAddressRequestProtocolMarshaller;
import com.amazonaws.services.snowball.model.transform.CreateAddressResultJsonUnmarshaller;
import com.amazonaws.services.snowball.model.transform.CreateClusterRequestProtocolMarshaller;
import com.amazonaws.services.snowball.model.transform.CreateClusterResultJsonUnmarshaller;
import com.amazonaws.services.snowball.model.transform.CreateJobRequestProtocolMarshaller;
import com.amazonaws.services.snowball.model.transform.CreateJobResultJsonUnmarshaller;
import com.amazonaws.services.snowball.model.transform.CreateReturnShippingLabelRequestProtocolMarshaller;
import com.amazonaws.services.snowball.model.transform.CreateReturnShippingLabelResultJsonUnmarshaller;
import com.amazonaws.services.snowball.model.transform.DescribeAddressRequestProtocolMarshaller;
import com.amazonaws.services.snowball.model.transform.DescribeAddressResultJsonUnmarshaller;
import com.amazonaws.services.snowball.model.transform.DescribeAddressesRequestProtocolMarshaller;
import com.amazonaws.services.snowball.model.transform.DescribeAddressesResultJsonUnmarshaller;
import com.amazonaws.services.snowball.model.transform.DescribeClusterRequestProtocolMarshaller;
import com.amazonaws.services.snowball.model.transform.DescribeClusterResultJsonUnmarshaller;
import com.amazonaws.services.snowball.model.transform.DescribeJobRequestProtocolMarshaller;
import com.amazonaws.services.snowball.model.transform.DescribeJobResultJsonUnmarshaller;
import com.amazonaws.services.snowball.model.transform.DescribeReturnShippingLabelRequestProtocolMarshaller;
import com.amazonaws.services.snowball.model.transform.DescribeReturnShippingLabelResultJsonUnmarshaller;
import com.amazonaws.services.snowball.model.transform.Ec2RequestFailedExceptionUnmarshaller;
import com.amazonaws.services.snowball.model.transform.GetJobManifestRequestProtocolMarshaller;
import com.amazonaws.services.snowball.model.transform.GetJobManifestResultJsonUnmarshaller;
import com.amazonaws.services.snowball.model.transform.GetJobUnlockCodeRequestProtocolMarshaller;
import com.amazonaws.services.snowball.model.transform.GetJobUnlockCodeResultJsonUnmarshaller;
import com.amazonaws.services.snowball.model.transform.GetSnowballUsageRequestProtocolMarshaller;
import com.amazonaws.services.snowball.model.transform.GetSnowballUsageResultJsonUnmarshaller;
import com.amazonaws.services.snowball.model.transform.GetSoftwareUpdatesRequestProtocolMarshaller;
import com.amazonaws.services.snowball.model.transform.GetSoftwareUpdatesResultJsonUnmarshaller;
import com.amazonaws.services.snowball.model.transform.InvalidAddressExceptionUnmarshaller;
import com.amazonaws.services.snowball.model.transform.InvalidInputCombinationExceptionUnmarshaller;
import com.amazonaws.services.snowball.model.transform.InvalidJobStateExceptionUnmarshaller;
import com.amazonaws.services.snowball.model.transform.InvalidNextTokenExceptionUnmarshaller;
import com.amazonaws.services.snowball.model.transform.InvalidResourceExceptionUnmarshaller;
import com.amazonaws.services.snowball.model.transform.KMSRequestFailedExceptionUnmarshaller;
import com.amazonaws.services.snowball.model.transform.ListClusterJobsRequestProtocolMarshaller;
import com.amazonaws.services.snowball.model.transform.ListClusterJobsResultJsonUnmarshaller;
import com.amazonaws.services.snowball.model.transform.ListClustersRequestProtocolMarshaller;
import com.amazonaws.services.snowball.model.transform.ListClustersResultJsonUnmarshaller;
import com.amazonaws.services.snowball.model.transform.ListCompatibleImagesRequestProtocolMarshaller;
import com.amazonaws.services.snowball.model.transform.ListCompatibleImagesResultJsonUnmarshaller;
import com.amazonaws.services.snowball.model.transform.ListJobsRequestProtocolMarshaller;
import com.amazonaws.services.snowball.model.transform.ListJobsResultJsonUnmarshaller;
import com.amazonaws.services.snowball.model.transform.ReturnShippingLabelAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.snowball.model.transform.UnsupportedAddressExceptionUnmarshaller;
import com.amazonaws.services.snowball.model.transform.UpdateClusterRequestProtocolMarshaller;
import com.amazonaws.services.snowball.model.transform.UpdateClusterResultJsonUnmarshaller;
import com.amazonaws.services.snowball.model.transform.UpdateJobRequestProtocolMarshaller;
import com.amazonaws.services.snowball.model.transform.UpdateJobResultJsonUnmarshaller;
import com.amazonaws.services.snowball.model.transform.UpdateJobShipmentStateRequestProtocolMarshaller;
import com.amazonaws.services.snowball.model.transform.UpdateJobShipmentStateResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonSnowballClient
extends AmazonWebServiceClient
implements AmazonSnowball {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonSnowball.class);
    private static final String DEFAULT_SIGNING_NAME = "snowball";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidJobStateException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidJobStateExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidResourceException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidResourceExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ReturnShippingLabelAlreadyExistsException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ReturnShippingLabelAlreadyExistsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("KMSRequestFailedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)KMSRequestFailedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedAddressException").withExceptionUnmarshaller((JsonErrorUnmarshaller)UnsupportedAddressExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ClusterLimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ClusterLimitExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidInputCombinationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidInputCombinationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("Ec2RequestFailedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)Ec2RequestFailedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidNextTokenException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidNextTokenExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidAddressException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidAddressExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonSnowballException.class));

    @Deprecated
    public AmazonSnowballClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    @Deprecated
    public AmazonSnowballClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    @Deprecated
    public AmazonSnowballClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AmazonSnowballClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.advancedConfig = AdvancedConfig.EMPTY;
        this.init();
    }

    @Deprecated
    public AmazonSnowballClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AmazonSnowballClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AmazonSnowballClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.advancedConfig = AdvancedConfig.EMPTY;
        this.init();
    }

    public static AmazonSnowballClientBuilder builder() {
        return AmazonSnowballClientBuilder.standard();
    }

    AmazonSnowballClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonSnowballClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("snowball.us-east-1.amazonaws.com/");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/snowball/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/snowball/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CancelClusterResult cancelCluster(CancelClusterRequest request) {
        request = (CancelClusterRequest)this.beforeClientExecution(request);
        return this.executeCancelCluster(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CancelClusterResult executeCancelCluster(CancelClusterRequest cancelClusterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(cancelClusterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CancelClusterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CancelClusterRequestProtocolMarshaller(protocolFactory).marshall((CancelClusterRequest)super.beforeMarshalling((AmazonWebServiceRequest)cancelClusterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Snowball");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CancelCluster");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CancelClusterResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CancelClusterResult cancelClusterResult = (CancelClusterResult)response.getAwsResponse();
            return cancelClusterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CancelJobResult cancelJob(CancelJobRequest request) {
        request = (CancelJobRequest)this.beforeClientExecution(request);
        return this.executeCancelJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CancelJobResult executeCancelJob(CancelJobRequest cancelJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(cancelJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CancelJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CancelJobRequestProtocolMarshaller(protocolFactory).marshall((CancelJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)cancelJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Snowball");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CancelJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CancelJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CancelJobResult cancelJobResult = (CancelJobResult)response.getAwsResponse();
            return cancelJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateAddressResult createAddress(CreateAddressRequest request) {
        request = (CreateAddressRequest)this.beforeClientExecution(request);
        return this.executeCreateAddress(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateAddressResult executeCreateAddress(CreateAddressRequest createAddressRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createAddressRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateAddressRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateAddressRequestProtocolMarshaller(protocolFactory).marshall((CreateAddressRequest)super.beforeMarshalling((AmazonWebServiceRequest)createAddressRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Snowball");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateAddress");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateAddressResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateAddressResult createAddressResult = (CreateAddressResult)response.getAwsResponse();
            return createAddressResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateClusterResult createCluster(CreateClusterRequest request) {
        request = (CreateClusterRequest)this.beforeClientExecution(request);
        return this.executeCreateCluster(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateClusterResult executeCreateCluster(CreateClusterRequest createClusterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createClusterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateClusterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateClusterRequestProtocolMarshaller(protocolFactory).marshall((CreateClusterRequest)super.beforeMarshalling((AmazonWebServiceRequest)createClusterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Snowball");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateCluster");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateClusterResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateClusterResult createClusterResult = (CreateClusterResult)response.getAwsResponse();
            return createClusterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateJobResult createJob(CreateJobRequest request) {
        request = (CreateJobRequest)this.beforeClientExecution(request);
        return this.executeCreateJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateJobResult executeCreateJob(CreateJobRequest createJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateJobRequestProtocolMarshaller(protocolFactory).marshall((CreateJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)createJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Snowball");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateJobResult createJobResult = (CreateJobResult)response.getAwsResponse();
            return createJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateReturnShippingLabelResult createReturnShippingLabel(CreateReturnShippingLabelRequest request) {
        request = (CreateReturnShippingLabelRequest)this.beforeClientExecution(request);
        return this.executeCreateReturnShippingLabel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateReturnShippingLabelResult executeCreateReturnShippingLabel(CreateReturnShippingLabelRequest createReturnShippingLabelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createReturnShippingLabelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateReturnShippingLabelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateReturnShippingLabelRequestProtocolMarshaller(protocolFactory).marshall((CreateReturnShippingLabelRequest)super.beforeMarshalling((AmazonWebServiceRequest)createReturnShippingLabelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Snowball");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateReturnShippingLabel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateReturnShippingLabelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateReturnShippingLabelResult createReturnShippingLabelResult = (CreateReturnShippingLabelResult)response.getAwsResponse();
            return createReturnShippingLabelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeAddressResult describeAddress(DescribeAddressRequest request) {
        request = (DescribeAddressRequest)this.beforeClientExecution(request);
        return this.executeDescribeAddress(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeAddressResult executeDescribeAddress(DescribeAddressRequest describeAddressRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAddressRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAddressRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAddressRequestProtocolMarshaller(protocolFactory).marshall((DescribeAddressRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeAddressRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Snowball");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeAddress");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeAddressResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeAddressResult describeAddressResult = (DescribeAddressResult)response.getAwsResponse();
            return describeAddressResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeAddressesResult describeAddresses(DescribeAddressesRequest request) {
        request = (DescribeAddressesRequest)this.beforeClientExecution(request);
        return this.executeDescribeAddresses(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeAddressesResult executeDescribeAddresses(DescribeAddressesRequest describeAddressesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAddressesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAddressesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAddressesRequestProtocolMarshaller(protocolFactory).marshall((DescribeAddressesRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeAddressesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Snowball");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeAddresses");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeAddressesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeAddressesResult describeAddressesResult = (DescribeAddressesResult)response.getAwsResponse();
            return describeAddressesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeClusterResult describeCluster(DescribeClusterRequest request) {
        request = (DescribeClusterRequest)this.beforeClientExecution(request);
        return this.executeDescribeCluster(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeClusterResult executeDescribeCluster(DescribeClusterRequest describeClusterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeClusterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeClusterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeClusterRequestProtocolMarshaller(protocolFactory).marshall((DescribeClusterRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeClusterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Snowball");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeCluster");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeClusterResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeClusterResult describeClusterResult = (DescribeClusterResult)response.getAwsResponse();
            return describeClusterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeJobResult describeJob(DescribeJobRequest request) {
        request = (DescribeJobRequest)this.beforeClientExecution(request);
        return this.executeDescribeJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeJobResult executeDescribeJob(DescribeJobRequest describeJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeJobRequestProtocolMarshaller(protocolFactory).marshall((DescribeJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Snowball");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeJobResult describeJobResult = (DescribeJobResult)response.getAwsResponse();
            return describeJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeReturnShippingLabelResult describeReturnShippingLabel(DescribeReturnShippingLabelRequest request) {
        request = (DescribeReturnShippingLabelRequest)this.beforeClientExecution(request);
        return this.executeDescribeReturnShippingLabel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeReturnShippingLabelResult executeDescribeReturnShippingLabel(DescribeReturnShippingLabelRequest describeReturnShippingLabelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeReturnShippingLabelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeReturnShippingLabelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeReturnShippingLabelRequestProtocolMarshaller(protocolFactory).marshall((DescribeReturnShippingLabelRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeReturnShippingLabelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Snowball");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeReturnShippingLabel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeReturnShippingLabelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeReturnShippingLabelResult describeReturnShippingLabelResult = (DescribeReturnShippingLabelResult)response.getAwsResponse();
            return describeReturnShippingLabelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetJobManifestResult getJobManifest(GetJobManifestRequest request) {
        request = (GetJobManifestRequest)this.beforeClientExecution(request);
        return this.executeGetJobManifest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetJobManifestResult executeGetJobManifest(GetJobManifestRequest getJobManifestRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getJobManifestRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetJobManifestRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetJobManifestRequestProtocolMarshaller(protocolFactory).marshall((GetJobManifestRequest)super.beforeMarshalling((AmazonWebServiceRequest)getJobManifestRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Snowball");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetJobManifest");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetJobManifestResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetJobManifestResult getJobManifestResult = (GetJobManifestResult)response.getAwsResponse();
            return getJobManifestResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetJobUnlockCodeResult getJobUnlockCode(GetJobUnlockCodeRequest request) {
        request = (GetJobUnlockCodeRequest)this.beforeClientExecution(request);
        return this.executeGetJobUnlockCode(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetJobUnlockCodeResult executeGetJobUnlockCode(GetJobUnlockCodeRequest getJobUnlockCodeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getJobUnlockCodeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetJobUnlockCodeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetJobUnlockCodeRequestProtocolMarshaller(protocolFactory).marshall((GetJobUnlockCodeRequest)super.beforeMarshalling((AmazonWebServiceRequest)getJobUnlockCodeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Snowball");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetJobUnlockCode");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetJobUnlockCodeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetJobUnlockCodeResult getJobUnlockCodeResult = (GetJobUnlockCodeResult)response.getAwsResponse();
            return getJobUnlockCodeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetSnowballUsageResult getSnowballUsage(GetSnowballUsageRequest request) {
        request = (GetSnowballUsageRequest)this.beforeClientExecution(request);
        return this.executeGetSnowballUsage(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetSnowballUsageResult executeGetSnowballUsage(GetSnowballUsageRequest getSnowballUsageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSnowballUsageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSnowballUsageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSnowballUsageRequestProtocolMarshaller(protocolFactory).marshall((GetSnowballUsageRequest)super.beforeMarshalling((AmazonWebServiceRequest)getSnowballUsageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Snowball");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetSnowballUsage");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetSnowballUsageResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetSnowballUsageResult getSnowballUsageResult = (GetSnowballUsageResult)response.getAwsResponse();
            return getSnowballUsageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetSoftwareUpdatesResult getSoftwareUpdates(GetSoftwareUpdatesRequest request) {
        request = (GetSoftwareUpdatesRequest)this.beforeClientExecution(request);
        return this.executeGetSoftwareUpdates(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetSoftwareUpdatesResult executeGetSoftwareUpdates(GetSoftwareUpdatesRequest getSoftwareUpdatesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSoftwareUpdatesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSoftwareUpdatesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSoftwareUpdatesRequestProtocolMarshaller(protocolFactory).marshall((GetSoftwareUpdatesRequest)super.beforeMarshalling((AmazonWebServiceRequest)getSoftwareUpdatesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Snowball");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetSoftwareUpdates");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetSoftwareUpdatesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetSoftwareUpdatesResult getSoftwareUpdatesResult = (GetSoftwareUpdatesResult)response.getAwsResponse();
            return getSoftwareUpdatesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListClusterJobsResult listClusterJobs(ListClusterJobsRequest request) {
        request = (ListClusterJobsRequest)this.beforeClientExecution(request);
        return this.executeListClusterJobs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListClusterJobsResult executeListClusterJobs(ListClusterJobsRequest listClusterJobsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listClusterJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListClusterJobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListClusterJobsRequestProtocolMarshaller(protocolFactory).marshall((ListClusterJobsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listClusterJobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Snowball");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListClusterJobs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListClusterJobsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListClusterJobsResult listClusterJobsResult = (ListClusterJobsResult)response.getAwsResponse();
            return listClusterJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListClustersResult listClusters(ListClustersRequest request) {
        request = (ListClustersRequest)this.beforeClientExecution(request);
        return this.executeListClusters(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListClustersResult executeListClusters(ListClustersRequest listClustersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listClustersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListClustersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListClustersRequestProtocolMarshaller(protocolFactory).marshall((ListClustersRequest)super.beforeMarshalling((AmazonWebServiceRequest)listClustersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Snowball");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListClusters");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListClustersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListClustersResult listClustersResult = (ListClustersResult)response.getAwsResponse();
            return listClustersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListCompatibleImagesResult listCompatibleImages(ListCompatibleImagesRequest request) {
        request = (ListCompatibleImagesRequest)this.beforeClientExecution(request);
        return this.executeListCompatibleImages(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListCompatibleImagesResult executeListCompatibleImages(ListCompatibleImagesRequest listCompatibleImagesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listCompatibleImagesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListCompatibleImagesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListCompatibleImagesRequestProtocolMarshaller(protocolFactory).marshall((ListCompatibleImagesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listCompatibleImagesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Snowball");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListCompatibleImages");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListCompatibleImagesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListCompatibleImagesResult listCompatibleImagesResult = (ListCompatibleImagesResult)response.getAwsResponse();
            return listCompatibleImagesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListJobsResult listJobs(ListJobsRequest request) {
        request = (ListJobsRequest)this.beforeClientExecution(request);
        return this.executeListJobs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListJobsResult executeListJobs(ListJobsRequest listJobsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListJobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListJobsRequestProtocolMarshaller(protocolFactory).marshall((ListJobsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listJobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Snowball");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListJobs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListJobsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListJobsResult listJobsResult = (ListJobsResult)response.getAwsResponse();
            return listJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateClusterResult updateCluster(UpdateClusterRequest request) {
        request = (UpdateClusterRequest)this.beforeClientExecution(request);
        return this.executeUpdateCluster(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateClusterResult executeUpdateCluster(UpdateClusterRequest updateClusterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateClusterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateClusterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateClusterRequestProtocolMarshaller(protocolFactory).marshall((UpdateClusterRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateClusterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Snowball");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateCluster");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateClusterResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateClusterResult updateClusterResult = (UpdateClusterResult)response.getAwsResponse();
            return updateClusterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateJobResult updateJob(UpdateJobRequest request) {
        request = (UpdateJobRequest)this.beforeClientExecution(request);
        return this.executeUpdateJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateJobResult executeUpdateJob(UpdateJobRequest updateJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateJobRequestProtocolMarshaller(protocolFactory).marshall((UpdateJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Snowball");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateJobResult updateJobResult = (UpdateJobResult)response.getAwsResponse();
            return updateJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateJobShipmentStateResult updateJobShipmentState(UpdateJobShipmentStateRequest request) {
        request = (UpdateJobShipmentStateRequest)this.beforeClientExecution(request);
        return this.executeUpdateJobShipmentState(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateJobShipmentStateResult executeUpdateJobShipmentState(UpdateJobShipmentStateRequest updateJobShipmentStateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateJobShipmentStateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateJobShipmentStateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateJobShipmentStateRequestProtocolMarshaller(protocolFactory).marshall((UpdateJobShipmentStateRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateJobShipmentStateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Snowball");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateJobShipmentState");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateJobShipmentStateResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateJobShipmentStateResult updateJobShipmentStateResult = (UpdateJobShipmentStateResult)response.getAwsResponse();
            return updateJobShipmentStateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

