/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simspaceweaver;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.simspaceweaver.AWSSimSpaceWeaverAsync;
import com.amazonaws.services.simspaceweaver.AWSSimSpaceWeaverAsyncClientBuilder;
import com.amazonaws.services.simspaceweaver.AWSSimSpaceWeaverClient;
import com.amazonaws.services.simspaceweaver.model.CreateSnapshotRequest;
import com.amazonaws.services.simspaceweaver.model.CreateSnapshotResult;
import com.amazonaws.services.simspaceweaver.model.DeleteAppRequest;
import com.amazonaws.services.simspaceweaver.model.DeleteAppResult;
import com.amazonaws.services.simspaceweaver.model.DeleteSimulationRequest;
import com.amazonaws.services.simspaceweaver.model.DeleteSimulationResult;
import com.amazonaws.services.simspaceweaver.model.DescribeAppRequest;
import com.amazonaws.services.simspaceweaver.model.DescribeAppResult;
import com.amazonaws.services.simspaceweaver.model.DescribeSimulationRequest;
import com.amazonaws.services.simspaceweaver.model.DescribeSimulationResult;
import com.amazonaws.services.simspaceweaver.model.ListAppsRequest;
import com.amazonaws.services.simspaceweaver.model.ListAppsResult;
import com.amazonaws.services.simspaceweaver.model.ListSimulationsRequest;
import com.amazonaws.services.simspaceweaver.model.ListSimulationsResult;
import com.amazonaws.services.simspaceweaver.model.ListTagsForResourceRequest;
import com.amazonaws.services.simspaceweaver.model.ListTagsForResourceResult;
import com.amazonaws.services.simspaceweaver.model.StartAppRequest;
import com.amazonaws.services.simspaceweaver.model.StartAppResult;
import com.amazonaws.services.simspaceweaver.model.StartClockRequest;
import com.amazonaws.services.simspaceweaver.model.StartClockResult;
import com.amazonaws.services.simspaceweaver.model.StartSimulationRequest;
import com.amazonaws.services.simspaceweaver.model.StartSimulationResult;
import com.amazonaws.services.simspaceweaver.model.StopAppRequest;
import com.amazonaws.services.simspaceweaver.model.StopAppResult;
import com.amazonaws.services.simspaceweaver.model.StopClockRequest;
import com.amazonaws.services.simspaceweaver.model.StopClockResult;
import com.amazonaws.services.simspaceweaver.model.StopSimulationRequest;
import com.amazonaws.services.simspaceweaver.model.StopSimulationResult;
import com.amazonaws.services.simspaceweaver.model.TagResourceRequest;
import com.amazonaws.services.simspaceweaver.model.TagResourceResult;
import com.amazonaws.services.simspaceweaver.model.UntagResourceRequest;
import com.amazonaws.services.simspaceweaver.model.UntagResourceResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSSimSpaceWeaverAsyncClient
extends AWSSimSpaceWeaverClient
implements AWSSimSpaceWeaverAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSSimSpaceWeaverAsyncClientBuilder asyncBuilder() {
        return AWSSimSpaceWeaverAsyncClientBuilder.standard();
    }

    AWSSimSpaceWeaverAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSSimSpaceWeaverAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateSnapshotResult> createSnapshotAsync(CreateSnapshotRequest request) {
        return this.createSnapshotAsync(request, null);
    }

    @Override
    public Future<CreateSnapshotResult> createSnapshotAsync(CreateSnapshotRequest request, final AsyncHandler<CreateSnapshotRequest, CreateSnapshotResult> asyncHandler) {
        final CreateSnapshotRequest finalRequest = (CreateSnapshotRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateSnapshotResult>(){

            @Override
            public CreateSnapshotResult call() throws Exception {
                CreateSnapshotResult result = null;
                try {
                    result = AWSSimSpaceWeaverAsyncClient.this.executeCreateSnapshot(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteAppResult> deleteAppAsync(DeleteAppRequest request) {
        return this.deleteAppAsync(request, null);
    }

    @Override
    public Future<DeleteAppResult> deleteAppAsync(DeleteAppRequest request, final AsyncHandler<DeleteAppRequest, DeleteAppResult> asyncHandler) {
        final DeleteAppRequest finalRequest = (DeleteAppRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteAppResult>(){

            @Override
            public DeleteAppResult call() throws Exception {
                DeleteAppResult result = null;
                try {
                    result = AWSSimSpaceWeaverAsyncClient.this.executeDeleteApp(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSimulationResult> deleteSimulationAsync(DeleteSimulationRequest request) {
        return this.deleteSimulationAsync(request, null);
    }

    @Override
    public Future<DeleteSimulationResult> deleteSimulationAsync(DeleteSimulationRequest request, final AsyncHandler<DeleteSimulationRequest, DeleteSimulationResult> asyncHandler) {
        final DeleteSimulationRequest finalRequest = (DeleteSimulationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteSimulationResult>(){

            @Override
            public DeleteSimulationResult call() throws Exception {
                DeleteSimulationResult result = null;
                try {
                    result = AWSSimSpaceWeaverAsyncClient.this.executeDeleteSimulation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAppResult> describeAppAsync(DescribeAppRequest request) {
        return this.describeAppAsync(request, null);
    }

    @Override
    public Future<DescribeAppResult> describeAppAsync(DescribeAppRequest request, final AsyncHandler<DescribeAppRequest, DescribeAppResult> asyncHandler) {
        final DescribeAppRequest finalRequest = (DescribeAppRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeAppResult>(){

            @Override
            public DescribeAppResult call() throws Exception {
                DescribeAppResult result = null;
                try {
                    result = AWSSimSpaceWeaverAsyncClient.this.executeDescribeApp(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeSimulationResult> describeSimulationAsync(DescribeSimulationRequest request) {
        return this.describeSimulationAsync(request, null);
    }

    @Override
    public Future<DescribeSimulationResult> describeSimulationAsync(DescribeSimulationRequest request, final AsyncHandler<DescribeSimulationRequest, DescribeSimulationResult> asyncHandler) {
        final DescribeSimulationRequest finalRequest = (DescribeSimulationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeSimulationResult>(){

            @Override
            public DescribeSimulationResult call() throws Exception {
                DescribeSimulationResult result = null;
                try {
                    result = AWSSimSpaceWeaverAsyncClient.this.executeDescribeSimulation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAppsResult> listAppsAsync(ListAppsRequest request) {
        return this.listAppsAsync(request, null);
    }

    @Override
    public Future<ListAppsResult> listAppsAsync(ListAppsRequest request, final AsyncHandler<ListAppsRequest, ListAppsResult> asyncHandler) {
        final ListAppsRequest finalRequest = (ListAppsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAppsResult>(){

            @Override
            public ListAppsResult call() throws Exception {
                ListAppsResult result = null;
                try {
                    result = AWSSimSpaceWeaverAsyncClient.this.executeListApps(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSimulationsResult> listSimulationsAsync(ListSimulationsRequest request) {
        return this.listSimulationsAsync(request, null);
    }

    @Override
    public Future<ListSimulationsResult> listSimulationsAsync(ListSimulationsRequest request, final AsyncHandler<ListSimulationsRequest, ListSimulationsResult> asyncHandler) {
        final ListSimulationsRequest finalRequest = (ListSimulationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSimulationsResult>(){

            @Override
            public ListSimulationsResult call() throws Exception {
                ListSimulationsResult result = null;
                try {
                    result = AWSSimSpaceWeaverAsyncClient.this.executeListSimulations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSSimSpaceWeaverAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartAppResult> startAppAsync(StartAppRequest request) {
        return this.startAppAsync(request, null);
    }

    @Override
    public Future<StartAppResult> startAppAsync(StartAppRequest request, final AsyncHandler<StartAppRequest, StartAppResult> asyncHandler) {
        final StartAppRequest finalRequest = (StartAppRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartAppResult>(){

            @Override
            public StartAppResult call() throws Exception {
                StartAppResult result = null;
                try {
                    result = AWSSimSpaceWeaverAsyncClient.this.executeStartApp(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartClockResult> startClockAsync(StartClockRequest request) {
        return this.startClockAsync(request, null);
    }

    @Override
    public Future<StartClockResult> startClockAsync(StartClockRequest request, final AsyncHandler<StartClockRequest, StartClockResult> asyncHandler) {
        final StartClockRequest finalRequest = (StartClockRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartClockResult>(){

            @Override
            public StartClockResult call() throws Exception {
                StartClockResult result = null;
                try {
                    result = AWSSimSpaceWeaverAsyncClient.this.executeStartClock(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartSimulationResult> startSimulationAsync(StartSimulationRequest request) {
        return this.startSimulationAsync(request, null);
    }

    @Override
    public Future<StartSimulationResult> startSimulationAsync(StartSimulationRequest request, final AsyncHandler<StartSimulationRequest, StartSimulationResult> asyncHandler) {
        final StartSimulationRequest finalRequest = (StartSimulationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartSimulationResult>(){

            @Override
            public StartSimulationResult call() throws Exception {
                StartSimulationResult result = null;
                try {
                    result = AWSSimSpaceWeaverAsyncClient.this.executeStartSimulation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopAppResult> stopAppAsync(StopAppRequest request) {
        return this.stopAppAsync(request, null);
    }

    @Override
    public Future<StopAppResult> stopAppAsync(StopAppRequest request, final AsyncHandler<StopAppRequest, StopAppResult> asyncHandler) {
        final StopAppRequest finalRequest = (StopAppRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopAppResult>(){

            @Override
            public StopAppResult call() throws Exception {
                StopAppResult result = null;
                try {
                    result = AWSSimSpaceWeaverAsyncClient.this.executeStopApp(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopClockResult> stopClockAsync(StopClockRequest request) {
        return this.stopClockAsync(request, null);
    }

    @Override
    public Future<StopClockResult> stopClockAsync(StopClockRequest request, final AsyncHandler<StopClockRequest, StopClockResult> asyncHandler) {
        final StopClockRequest finalRequest = (StopClockRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopClockResult>(){

            @Override
            public StopClockResult call() throws Exception {
                StopClockResult result = null;
                try {
                    result = AWSSimSpaceWeaverAsyncClient.this.executeStopClock(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopSimulationResult> stopSimulationAsync(StopSimulationRequest request) {
        return this.stopSimulationAsync(request, null);
    }

    @Override
    public Future<StopSimulationResult> stopSimulationAsync(StopSimulationRequest request, final AsyncHandler<StopSimulationRequest, StopSimulationResult> asyncHandler) {
        final StopSimulationRequest finalRequest = (StopSimulationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopSimulationResult>(){

            @Override
            public StopSimulationResult call() throws Exception {
                StopSimulationResult result = null;
                try {
                    result = AWSSimSpaceWeaverAsyncClient.this.executeStopSimulation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSSimSpaceWeaverAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSSimSpaceWeaverAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

