/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simpledb.model.BatchPutAttributesRequest;
import com.amazonaws.services.simpledb.model.ReplaceableAttribute;
import com.amazonaws.services.simpledb.model.ReplaceableItem;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class BatchPutAttributesRequestMarshaller
implements Marshaller<Request<BatchPutAttributesRequest>, BatchPutAttributesRequest> {
    public Request<BatchPutAttributesRequest> marshall(BatchPutAttributesRequest batchPutAttributesRequest) {
        SdkInternalList itemsList;
        if (batchPutAttributesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)batchPutAttributesRequest, "AmazonSimpleDB");
        request.addParameter("Action", "BatchPutAttributes");
        request.addParameter("Version", "2009-04-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (batchPutAttributesRequest.getDomainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString((String)batchPutAttributesRequest.getDomainName()));
        }
        if (!(itemsList = (SdkInternalList)batchPutAttributesRequest.getItems()).isEmpty() || !itemsList.isAutoConstruct()) {
            int itemsListIndex = 1;
            for (ReplaceableItem itemsListValue : itemsList) {
                SdkInternalList attributesList;
                if (itemsListValue.getName() != null) {
                    request.addParameter("Item." + itemsListIndex + ".ItemName", StringUtils.fromString((String)itemsListValue.getName()));
                }
                if (!(attributesList = (SdkInternalList)itemsListValue.getAttributes()).isEmpty() || !attributesList.isAutoConstruct()) {
                    int attributesListIndex = 1;
                    for (ReplaceableAttribute attributesListValue : attributesList) {
                        if (attributesListValue.getName() != null) {
                            request.addParameter("Item." + itemsListIndex + ".Attribute." + attributesListIndex + ".Name", StringUtils.fromString((String)attributesListValue.getName()));
                        }
                        if (attributesListValue.getValue() != null) {
                            request.addParameter("Item." + itemsListIndex + ".Attribute." + attributesListIndex + ".Value", StringUtils.fromString((String)attributesListValue.getValue()));
                        }
                        if (attributesListValue.getReplace() != null) {
                            request.addParameter("Item." + itemsListIndex + ".Attribute." + attributesListIndex + ".Replace", StringUtils.fromBoolean((Boolean)attributesListValue.getReplace()));
                        }
                        ++attributesListIndex;
                    }
                }
                ++itemsListIndex;
            }
        }
        return request;
    }
}

