/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.simpledb.model.Attribute;
import com.amazonaws.services.simpledb.model.BatchDeleteAttributesRequest;
import com.amazonaws.services.simpledb.model.DeletableItem;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class BatchDeleteAttributesRequestMarshaller
implements Marshaller<Request<BatchDeleteAttributesRequest>, BatchDeleteAttributesRequest> {
    public Request<BatchDeleteAttributesRequest> marshall(BatchDeleteAttributesRequest batchDeleteAttributesRequest) {
        if (batchDeleteAttributesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)batchDeleteAttributesRequest, "AmazonSimpleDB");
        request.addParameter("Action", "BatchDeleteAttributes");
        request.addParameter("Version", "2009-04-15");
        if (batchDeleteAttributesRequest.getDomainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString((String)batchDeleteAttributesRequest.getDomainName()));
        }
        List<DeletableItem> itemsList = batchDeleteAttributesRequest.getItems();
        int itemsListIndex = 1;
        for (DeletableItem itemsListValue : itemsList) {
            DeletableItem deletableItemMember = itemsListValue;
            if (deletableItemMember != null) {
                if (deletableItemMember.getName() != null) {
                    request.addParameter("Item." + itemsListIndex + ".ItemName", StringUtils.fromString((String)deletableItemMember.getName()));
                }
                List<Attribute> attributesList = deletableItemMember.getAttributes();
                int attributesListIndex = 1;
                for (Attribute attributesListValue : attributesList) {
                    Attribute attributeMember = attributesListValue;
                    if (attributeMember != null) {
                        if (attributeMember.getName() != null) {
                            request.addParameter("Item." + itemsListIndex + ".Attribute." + attributesListIndex + ".Name", StringUtils.fromString((String)attributeMember.getName()));
                        }
                        if (attributeMember.getAlternateNameEncoding() != null) {
                            request.addParameter("Item." + itemsListIndex + ".Attribute." + attributesListIndex + ".AlternateNameEncoding", StringUtils.fromString((String)attributeMember.getAlternateNameEncoding()));
                        }
                        if (attributeMember.getValue() != null) {
                            request.addParameter("Item." + itemsListIndex + ".Attribute." + attributesListIndex + ".Value", StringUtils.fromString((String)attributeMember.getValue()));
                        }
                        if (attributeMember.getAlternateValueEncoding() != null) {
                            request.addParameter("Item." + itemsListIndex + ".Attribute." + attributesListIndex + ".AlternateValueEncoding", StringUtils.fromString((String)attributeMember.getAlternateValueEncoding()));
                        }
                    }
                    ++attributesListIndex;
                }
            }
            ++itemsListIndex;
        }
        return request;
    }
}

