/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.simpledb.model.DeletableItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchDeleteAttributesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String domainName;
    private ListWithAutoConstructFlag<DeletableItem> items;

    public BatchDeleteAttributesRequest() {
    }

    public BatchDeleteAttributesRequest(String domainName, List<DeletableItem> items) {
        this.setDomainName(domainName);
        this.setItems(items);
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public BatchDeleteAttributesRequest withDomainName(String domainName) {
        this.domainName = domainName;
        return this;
    }

    public List<DeletableItem> getItems() {
        if (this.items == null) {
            this.items = new ListWithAutoConstructFlag();
            this.items.setAutoConstruct(true);
        }
        return this.items;
    }

    public void setItems(Collection<DeletableItem> items) {
        if (items == null) {
            this.items = null;
            return;
        }
        ListWithAutoConstructFlag itemsCopy = new ListWithAutoConstructFlag(items.size());
        itemsCopy.addAll(items);
        this.items = itemsCopy;
    }

    public BatchDeleteAttributesRequest withItems(DeletableItem ... items) {
        if (this.getItems() == null) {
            this.setItems(new ArrayList<DeletableItem>(items.length));
        }
        for (DeletableItem value : items) {
            this.getItems().add(value);
        }
        return this;
    }

    public BatchDeleteAttributesRequest withItems(Collection<DeletableItem> items) {
        if (items == null) {
            this.items = null;
        } else {
            ListWithAutoConstructFlag itemsCopy = new ListWithAutoConstructFlag(items.size());
            itemsCopy.addAll(items);
            this.items = itemsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDomainName() != null) {
            sb.append("DomainName: " + this.getDomainName() + ",");
        }
        if (this.getItems() != null) {
            sb.append("Items: " + this.getItems());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDomainName() == null ? 0 : this.getDomainName().hashCode());
        hashCode = 31 * hashCode + (this.getItems() == null ? 0 : this.getItems().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteAttributesRequest)) {
            return false;
        }
        BatchDeleteAttributesRequest other = (BatchDeleteAttributesRequest)obj;
        if (other.getDomainName() == null ^ this.getDomainName() == null) {
            return false;
        }
        if (other.getDomainName() != null && !other.getDomainName().equals(this.getDomainName())) {
            return false;
        }
        if (other.getItems() == null ^ this.getItems() == null) {
            return false;
        }
        return other.getItems() == null || other.getItems().equals(this.getItems());
    }

    public BatchDeleteAttributesRequest clone() {
        return (BatchDeleteAttributesRequest)super.clone();
    }
}

