/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.signer.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.signer.model.SigningProfileStatus;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListSigningProfilesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private Boolean includeCanceled;
    private Integer maxResults;
    private String nextToken;
    private String platformId;
    private List<String> statuses;

    public void setIncludeCanceled(Boolean includeCanceled) {
        this.includeCanceled = includeCanceled;
    }

    public Boolean getIncludeCanceled() {
        return this.includeCanceled;
    }

    public ListSigningProfilesRequest withIncludeCanceled(Boolean includeCanceled) {
        this.setIncludeCanceled(includeCanceled);
        return this;
    }

    public Boolean isIncludeCanceled() {
        return this.includeCanceled;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public ListSigningProfilesRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListSigningProfilesRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setPlatformId(String platformId) {
        this.platformId = platformId;
    }

    public String getPlatformId() {
        return this.platformId;
    }

    public ListSigningProfilesRequest withPlatformId(String platformId) {
        this.setPlatformId(platformId);
        return this;
    }

    public List<String> getStatuses() {
        return this.statuses;
    }

    public void setStatuses(Collection<String> statuses) {
        if (statuses == null) {
            this.statuses = null;
            return;
        }
        this.statuses = new ArrayList<String>(statuses);
    }

    public ListSigningProfilesRequest withStatuses(String ... statuses) {
        if (this.statuses == null) {
            this.setStatuses(new ArrayList<String>(statuses.length));
        }
        for (String ele : statuses) {
            this.statuses.add(ele);
        }
        return this;
    }

    public ListSigningProfilesRequest withStatuses(Collection<String> statuses) {
        this.setStatuses(statuses);
        return this;
    }

    public ListSigningProfilesRequest withStatuses(SigningProfileStatus ... statuses) {
        ArrayList<String> statusesCopy = new ArrayList<String>(statuses.length);
        for (SigningProfileStatus value : statuses) {
            statusesCopy.add(value.toString());
        }
        if (this.getStatuses() == null) {
            this.setStatuses(statusesCopy);
        } else {
            this.getStatuses().addAll(statusesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIncludeCanceled() != null) {
            sb.append("IncludeCanceled: ").append(this.getIncludeCanceled()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getPlatformId() != null) {
            sb.append("PlatformId: ").append(this.getPlatformId()).append(",");
        }
        if (this.getStatuses() != null) {
            sb.append("Statuses: ").append(this.getStatuses());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSigningProfilesRequest)) {
            return false;
        }
        ListSigningProfilesRequest other = (ListSigningProfilesRequest)obj;
        if (other.getIncludeCanceled() == null ^ this.getIncludeCanceled() == null) {
            return false;
        }
        if (other.getIncludeCanceled() != null && !other.getIncludeCanceled().equals(this.getIncludeCanceled())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getPlatformId() == null ^ this.getPlatformId() == null) {
            return false;
        }
        if (other.getPlatformId() != null && !other.getPlatformId().equals(this.getPlatformId())) {
            return false;
        }
        if (other.getStatuses() == null ^ this.getStatuses() == null) {
            return false;
        }
        return other.getStatuses() == null || other.getStatuses().equals(this.getStatuses());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIncludeCanceled() == null ? 0 : this.getIncludeCanceled().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getPlatformId() == null ? 0 : this.getPlatformId().hashCode());
        hashCode = 31 * hashCode + (this.getStatuses() == null ? 0 : this.getStatuses().hashCode());
        return hashCode;
    }

    public ListSigningProfilesRequest clone() {
        return (ListSigningProfilesRequest)super.clone();
    }
}

