/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.signer;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.signer.AWSsigner;
import com.amazonaws.services.signer.AWSsignerClientBuilder;
import com.amazonaws.services.signer.model.AWSsignerException;
import com.amazonaws.services.signer.model.AccessDeniedException;
import com.amazonaws.services.signer.model.CancelSigningProfileRequest;
import com.amazonaws.services.signer.model.CancelSigningProfileResult;
import com.amazonaws.services.signer.model.DescribeSigningJobRequest;
import com.amazonaws.services.signer.model.DescribeSigningJobResult;
import com.amazonaws.services.signer.model.GetSigningPlatformRequest;
import com.amazonaws.services.signer.model.GetSigningPlatformResult;
import com.amazonaws.services.signer.model.GetSigningProfileRequest;
import com.amazonaws.services.signer.model.GetSigningProfileResult;
import com.amazonaws.services.signer.model.InternalServiceErrorException;
import com.amazonaws.services.signer.model.ListSigningJobsRequest;
import com.amazonaws.services.signer.model.ListSigningJobsResult;
import com.amazonaws.services.signer.model.ListSigningPlatformsRequest;
import com.amazonaws.services.signer.model.ListSigningPlatformsResult;
import com.amazonaws.services.signer.model.ListSigningProfilesRequest;
import com.amazonaws.services.signer.model.ListSigningProfilesResult;
import com.amazonaws.services.signer.model.PutSigningProfileRequest;
import com.amazonaws.services.signer.model.PutSigningProfileResult;
import com.amazonaws.services.signer.model.ResourceNotFoundException;
import com.amazonaws.services.signer.model.StartSigningJobRequest;
import com.amazonaws.services.signer.model.StartSigningJobResult;
import com.amazonaws.services.signer.model.ThrottlingException;
import com.amazonaws.services.signer.model.ValidationException;
import com.amazonaws.services.signer.model.transform.CancelSigningProfileRequestProtocolMarshaller;
import com.amazonaws.services.signer.model.transform.CancelSigningProfileResultJsonUnmarshaller;
import com.amazonaws.services.signer.model.transform.DescribeSigningJobRequestProtocolMarshaller;
import com.amazonaws.services.signer.model.transform.DescribeSigningJobResultJsonUnmarshaller;
import com.amazonaws.services.signer.model.transform.GetSigningPlatformRequestProtocolMarshaller;
import com.amazonaws.services.signer.model.transform.GetSigningPlatformResultJsonUnmarshaller;
import com.amazonaws.services.signer.model.transform.GetSigningProfileRequestProtocolMarshaller;
import com.amazonaws.services.signer.model.transform.GetSigningProfileResultJsonUnmarshaller;
import com.amazonaws.services.signer.model.transform.ListSigningJobsRequestProtocolMarshaller;
import com.amazonaws.services.signer.model.transform.ListSigningJobsResultJsonUnmarshaller;
import com.amazonaws.services.signer.model.transform.ListSigningPlatformsRequestProtocolMarshaller;
import com.amazonaws.services.signer.model.transform.ListSigningPlatformsResultJsonUnmarshaller;
import com.amazonaws.services.signer.model.transform.ListSigningProfilesRequestProtocolMarshaller;
import com.amazonaws.services.signer.model.transform.ListSigningProfilesResultJsonUnmarshaller;
import com.amazonaws.services.signer.model.transform.PutSigningProfileRequestProtocolMarshaller;
import com.amazonaws.services.signer.model.transform.PutSigningProfileResultJsonUnmarshaller;
import com.amazonaws.services.signer.model.transform.StartSigningJobRequestProtocolMarshaller;
import com.amazonaws.services.signer.model.transform.StartSigningJobResultJsonUnmarshaller;
import com.amazonaws.services.signer.waiters.AWSsignerWaiters;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSsignerClient
extends AmazonWebServiceClient
implements AWSsigner {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSsigner.class);
    private static final String DEFAULT_SIGNING_NAME = "signer";
    private volatile AWSsignerWaiters waiters;
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withModeledClass(AccessDeniedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withModeledClass(ValidationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServiceErrorException").withModeledClass(InternalServiceErrorException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withModeledClass(ThrottlingException.class)).withBaseServiceExceptionClass(AWSsignerException.class));

    public static AWSsignerClientBuilder builder() {
        return AWSsignerClientBuilder.standard();
    }

    AWSsignerClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    AWSsignerClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("signer.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/signer/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/signer/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CancelSigningProfileResult cancelSigningProfile(CancelSigningProfileRequest request) {
        request = (CancelSigningProfileRequest)this.beforeClientExecution(request);
        return this.executeCancelSigningProfile(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CancelSigningProfileResult executeCancelSigningProfile(CancelSigningProfileRequest cancelSigningProfileRequest) {
        ExecutionContext executionContext = this.createExecutionContext(cancelSigningProfileRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CancelSigningProfileRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CancelSigningProfileRequestProtocolMarshaller(protocolFactory).marshall((CancelSigningProfileRequest)super.beforeMarshalling((AmazonWebServiceRequest)cancelSigningProfileRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CancelSigningProfile");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CancelSigningProfileResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CancelSigningProfileResult cancelSigningProfileResult = (CancelSigningProfileResult)response.getAwsResponse();
            return cancelSigningProfileResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeSigningJobResult describeSigningJob(DescribeSigningJobRequest request) {
        request = (DescribeSigningJobRequest)this.beforeClientExecution(request);
        return this.executeDescribeSigningJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeSigningJobResult executeDescribeSigningJob(DescribeSigningJobRequest describeSigningJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeSigningJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeSigningJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeSigningJobRequestProtocolMarshaller(protocolFactory).marshall((DescribeSigningJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeSigningJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeSigningJob");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeSigningJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeSigningJobResult describeSigningJobResult = (DescribeSigningJobResult)response.getAwsResponse();
            return describeSigningJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetSigningPlatformResult getSigningPlatform(GetSigningPlatformRequest request) {
        request = (GetSigningPlatformRequest)this.beforeClientExecution(request);
        return this.executeGetSigningPlatform(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetSigningPlatformResult executeGetSigningPlatform(GetSigningPlatformRequest getSigningPlatformRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSigningPlatformRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSigningPlatformRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSigningPlatformRequestProtocolMarshaller(protocolFactory).marshall((GetSigningPlatformRequest)super.beforeMarshalling((AmazonWebServiceRequest)getSigningPlatformRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetSigningPlatform");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetSigningPlatformResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetSigningPlatformResult getSigningPlatformResult = (GetSigningPlatformResult)response.getAwsResponse();
            return getSigningPlatformResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetSigningProfileResult getSigningProfile(GetSigningProfileRequest request) {
        request = (GetSigningProfileRequest)this.beforeClientExecution(request);
        return this.executeGetSigningProfile(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetSigningProfileResult executeGetSigningProfile(GetSigningProfileRequest getSigningProfileRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSigningProfileRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSigningProfileRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSigningProfileRequestProtocolMarshaller(protocolFactory).marshall((GetSigningProfileRequest)super.beforeMarshalling((AmazonWebServiceRequest)getSigningProfileRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetSigningProfile");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetSigningProfileResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetSigningProfileResult getSigningProfileResult = (GetSigningProfileResult)response.getAwsResponse();
            return getSigningProfileResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListSigningJobsResult listSigningJobs(ListSigningJobsRequest request) {
        request = (ListSigningJobsRequest)this.beforeClientExecution(request);
        return this.executeListSigningJobs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListSigningJobsResult executeListSigningJobs(ListSigningJobsRequest listSigningJobsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listSigningJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListSigningJobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListSigningJobsRequestProtocolMarshaller(protocolFactory).marshall((ListSigningJobsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listSigningJobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListSigningJobs");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListSigningJobsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListSigningJobsResult listSigningJobsResult = (ListSigningJobsResult)response.getAwsResponse();
            return listSigningJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListSigningPlatformsResult listSigningPlatforms(ListSigningPlatformsRequest request) {
        request = (ListSigningPlatformsRequest)this.beforeClientExecution(request);
        return this.executeListSigningPlatforms(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListSigningPlatformsResult executeListSigningPlatforms(ListSigningPlatformsRequest listSigningPlatformsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listSigningPlatformsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListSigningPlatformsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListSigningPlatformsRequestProtocolMarshaller(protocolFactory).marshall((ListSigningPlatformsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listSigningPlatformsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListSigningPlatforms");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListSigningPlatformsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListSigningPlatformsResult listSigningPlatformsResult = (ListSigningPlatformsResult)response.getAwsResponse();
            return listSigningPlatformsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListSigningProfilesResult listSigningProfiles(ListSigningProfilesRequest request) {
        request = (ListSigningProfilesRequest)this.beforeClientExecution(request);
        return this.executeListSigningProfiles(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListSigningProfilesResult executeListSigningProfiles(ListSigningProfilesRequest listSigningProfilesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listSigningProfilesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListSigningProfilesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListSigningProfilesRequestProtocolMarshaller(protocolFactory).marshall((ListSigningProfilesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listSigningProfilesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListSigningProfiles");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListSigningProfilesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListSigningProfilesResult listSigningProfilesResult = (ListSigningProfilesResult)response.getAwsResponse();
            return listSigningProfilesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutSigningProfileResult putSigningProfile(PutSigningProfileRequest request) {
        request = (PutSigningProfileRequest)this.beforeClientExecution(request);
        return this.executePutSigningProfile(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutSigningProfileResult executePutSigningProfile(PutSigningProfileRequest putSigningProfileRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putSigningProfileRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutSigningProfileRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutSigningProfileRequestProtocolMarshaller(protocolFactory).marshall((PutSigningProfileRequest)super.beforeMarshalling((AmazonWebServiceRequest)putSigningProfileRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutSigningProfile");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutSigningProfileResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutSigningProfileResult putSigningProfileResult = (PutSigningProfileResult)response.getAwsResponse();
            return putSigningProfileResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartSigningJobResult startSigningJob(StartSigningJobRequest request) {
        request = (StartSigningJobRequest)this.beforeClientExecution(request);
        return this.executeStartSigningJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartSigningJobResult executeStartSigningJob(StartSigningJobRequest startSigningJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startSigningJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartSigningJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartSigningJobRequestProtocolMarshaller(protocolFactory).marshall((StartSigningJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)startSigningJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartSigningJob");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartSigningJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartSigningJobResult startSigningJobResult = (StartSigningJobResult)response.getAwsResponse();
            return startSigningJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AWSsignerWaiters waiters() {
        if (this.waiters == null) {
            AWSsignerClient aWSsignerClient = this;
            synchronized (aWSsignerClient) {
                if (this.waiters == null) {
                    this.waiters = new AWSsignerWaiters(this);
                }
            }
        }
        return this.waiters;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.waiters != null) {
            this.waiters.shutdown();
        }
    }
}

