/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.shield.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.shield.model.AttackProperty;
import com.amazonaws.services.shield.model.Mitigation;
import com.amazonaws.services.shield.model.SubResourceSummary;
import com.amazonaws.services.shield.model.SummarizedCounter;
import com.amazonaws.services.shield.model.transform.AttackDetailMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class AttackDetail
implements Serializable,
Cloneable,
StructuredPojo {
    private String attackId;
    private String resourceArn;
    private List<SubResourceSummary> subResources;
    private Date startTime;
    private Date endTime;
    private List<SummarizedCounter> attackCounters;
    private List<AttackProperty> attackProperties;
    private List<Mitigation> mitigations;

    public void setAttackId(String attackId) {
        this.attackId = attackId;
    }

    public String getAttackId() {
        return this.attackId;
    }

    public AttackDetail withAttackId(String attackId) {
        this.setAttackId(attackId);
        return this;
    }

    public void setResourceArn(String resourceArn) {
        this.resourceArn = resourceArn;
    }

    public String getResourceArn() {
        return this.resourceArn;
    }

    public AttackDetail withResourceArn(String resourceArn) {
        this.setResourceArn(resourceArn);
        return this;
    }

    public List<SubResourceSummary> getSubResources() {
        return this.subResources;
    }

    public void setSubResources(Collection<SubResourceSummary> subResources) {
        if (subResources == null) {
            this.subResources = null;
            return;
        }
        this.subResources = new ArrayList<SubResourceSummary>(subResources);
    }

    public AttackDetail withSubResources(SubResourceSummary ... subResources) {
        if (this.subResources == null) {
            this.setSubResources(new ArrayList<SubResourceSummary>(subResources.length));
        }
        for (SubResourceSummary ele : subResources) {
            this.subResources.add(ele);
        }
        return this;
    }

    public AttackDetail withSubResources(Collection<SubResourceSummary> subResources) {
        this.setSubResources(subResources);
        return this;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public AttackDetail withStartTime(Date startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public AttackDetail withEndTime(Date endTime) {
        this.setEndTime(endTime);
        return this;
    }

    public List<SummarizedCounter> getAttackCounters() {
        return this.attackCounters;
    }

    public void setAttackCounters(Collection<SummarizedCounter> attackCounters) {
        if (attackCounters == null) {
            this.attackCounters = null;
            return;
        }
        this.attackCounters = new ArrayList<SummarizedCounter>(attackCounters);
    }

    public AttackDetail withAttackCounters(SummarizedCounter ... attackCounters) {
        if (this.attackCounters == null) {
            this.setAttackCounters(new ArrayList<SummarizedCounter>(attackCounters.length));
        }
        for (SummarizedCounter ele : attackCounters) {
            this.attackCounters.add(ele);
        }
        return this;
    }

    public AttackDetail withAttackCounters(Collection<SummarizedCounter> attackCounters) {
        this.setAttackCounters(attackCounters);
        return this;
    }

    public List<AttackProperty> getAttackProperties() {
        return this.attackProperties;
    }

    public void setAttackProperties(Collection<AttackProperty> attackProperties) {
        if (attackProperties == null) {
            this.attackProperties = null;
            return;
        }
        this.attackProperties = new ArrayList<AttackProperty>(attackProperties);
    }

    public AttackDetail withAttackProperties(AttackProperty ... attackProperties) {
        if (this.attackProperties == null) {
            this.setAttackProperties(new ArrayList<AttackProperty>(attackProperties.length));
        }
        for (AttackProperty ele : attackProperties) {
            this.attackProperties.add(ele);
        }
        return this;
    }

    public AttackDetail withAttackProperties(Collection<AttackProperty> attackProperties) {
        this.setAttackProperties(attackProperties);
        return this;
    }

    public List<Mitigation> getMitigations() {
        return this.mitigations;
    }

    public void setMitigations(Collection<Mitigation> mitigations) {
        if (mitigations == null) {
            this.mitigations = null;
            return;
        }
        this.mitigations = new ArrayList<Mitigation>(mitigations);
    }

    public AttackDetail withMitigations(Mitigation ... mitigations) {
        if (this.mitigations == null) {
            this.setMitigations(new ArrayList<Mitigation>(mitigations.length));
        }
        for (Mitigation ele : mitigations) {
            this.mitigations.add(ele);
        }
        return this;
    }

    public AttackDetail withMitigations(Collection<Mitigation> mitigations) {
        this.setMitigations(mitigations);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAttackId() != null) {
            sb.append("AttackId: ").append(this.getAttackId()).append(",");
        }
        if (this.getResourceArn() != null) {
            sb.append("ResourceArn: ").append(this.getResourceArn()).append(",");
        }
        if (this.getSubResources() != null) {
            sb.append("SubResources: ").append(this.getSubResources()).append(",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: ").append(this.getStartTime()).append(",");
        }
        if (this.getEndTime() != null) {
            sb.append("EndTime: ").append(this.getEndTime()).append(",");
        }
        if (this.getAttackCounters() != null) {
            sb.append("AttackCounters: ").append(this.getAttackCounters()).append(",");
        }
        if (this.getAttackProperties() != null) {
            sb.append("AttackProperties: ").append(this.getAttackProperties()).append(",");
        }
        if (this.getMitigations() != null) {
            sb.append("Mitigations: ").append(this.getMitigations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttackDetail)) {
            return false;
        }
        AttackDetail other = (AttackDetail)obj;
        if (other.getAttackId() == null ^ this.getAttackId() == null) {
            return false;
        }
        if (other.getAttackId() != null && !other.getAttackId().equals(this.getAttackId())) {
            return false;
        }
        if (other.getResourceArn() == null ^ this.getResourceArn() == null) {
            return false;
        }
        if (other.getResourceArn() != null && !other.getResourceArn().equals(this.getResourceArn())) {
            return false;
        }
        if (other.getSubResources() == null ^ this.getSubResources() == null) {
            return false;
        }
        if (other.getSubResources() != null && !other.getSubResources().equals(this.getSubResources())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        if (other.getEndTime() != null && !other.getEndTime().equals(this.getEndTime())) {
            return false;
        }
        if (other.getAttackCounters() == null ^ this.getAttackCounters() == null) {
            return false;
        }
        if (other.getAttackCounters() != null && !other.getAttackCounters().equals(this.getAttackCounters())) {
            return false;
        }
        if (other.getAttackProperties() == null ^ this.getAttackProperties() == null) {
            return false;
        }
        if (other.getAttackProperties() != null && !other.getAttackProperties().equals(this.getAttackProperties())) {
            return false;
        }
        if (other.getMitigations() == null ^ this.getMitigations() == null) {
            return false;
        }
        return other.getMitigations() == null || other.getMitigations().equals(this.getMitigations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAttackId() == null ? 0 : this.getAttackId().hashCode());
        hashCode = 31 * hashCode + (this.getResourceArn() == null ? 0 : this.getResourceArn().hashCode());
        hashCode = 31 * hashCode + (this.getSubResources() == null ? 0 : this.getSubResources().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getAttackCounters() == null ? 0 : this.getAttackCounters().hashCode());
        hashCode = 31 * hashCode + (this.getAttackProperties() == null ? 0 : this.getAttackProperties().hashCode());
        hashCode = 31 * hashCode + (this.getMitigations() == null ? 0 : this.getMitigations().hashCode());
        return hashCode;
    }

    public AttackDetail clone() {
        try {
            return (AttackDetail)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AttackDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

