/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.shield.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.shield.model.SubResourceType;
import com.amazonaws.services.shield.model.SummarizedAttackVector;
import com.amazonaws.services.shield.model.SummarizedCounter;
import com.amazonaws.services.shield.model.transform.SubResourceSummaryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SubResourceSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private String type;
    private String id;
    private List<SummarizedAttackVector> attackVectors;
    private List<SummarizedCounter> counters;

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public SubResourceSummary withType(String type) {
        this.setType(type);
        return this;
    }

    public void setType(SubResourceType type) {
        this.type = type.toString();
    }

    public SubResourceSummary withType(SubResourceType type) {
        this.setType(type);
        return this;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public SubResourceSummary withId(String id) {
        this.setId(id);
        return this;
    }

    public List<SummarizedAttackVector> getAttackVectors() {
        return this.attackVectors;
    }

    public void setAttackVectors(Collection<SummarizedAttackVector> attackVectors) {
        if (attackVectors == null) {
            this.attackVectors = null;
            return;
        }
        this.attackVectors = new ArrayList<SummarizedAttackVector>(attackVectors);
    }

    public SubResourceSummary withAttackVectors(SummarizedAttackVector ... attackVectors) {
        if (this.attackVectors == null) {
            this.setAttackVectors(new ArrayList<SummarizedAttackVector>(attackVectors.length));
        }
        for (SummarizedAttackVector ele : attackVectors) {
            this.attackVectors.add(ele);
        }
        return this;
    }

    public SubResourceSummary withAttackVectors(Collection<SummarizedAttackVector> attackVectors) {
        this.setAttackVectors(attackVectors);
        return this;
    }

    public List<SummarizedCounter> getCounters() {
        return this.counters;
    }

    public void setCounters(Collection<SummarizedCounter> counters) {
        if (counters == null) {
            this.counters = null;
            return;
        }
        this.counters = new ArrayList<SummarizedCounter>(counters);
    }

    public SubResourceSummary withCounters(SummarizedCounter ... counters) {
        if (this.counters == null) {
            this.setCounters(new ArrayList<SummarizedCounter>(counters.length));
        }
        for (SummarizedCounter ele : counters) {
            this.counters.add(ele);
        }
        return this;
    }

    public SubResourceSummary withCounters(Collection<SummarizedCounter> counters) {
        this.setCounters(counters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getAttackVectors() != null) {
            sb.append("AttackVectors: ").append(this.getAttackVectors()).append(",");
        }
        if (this.getCounters() != null) {
            sb.append("Counters: ").append(this.getCounters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubResourceSummary)) {
            return false;
        }
        SubResourceSummary other = (SubResourceSummary)obj;
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getAttackVectors() == null ^ this.getAttackVectors() == null) {
            return false;
        }
        if (other.getAttackVectors() != null && !other.getAttackVectors().equals(this.getAttackVectors())) {
            return false;
        }
        if (other.getCounters() == null ^ this.getCounters() == null) {
            return false;
        }
        return other.getCounters() == null || other.getCounters().equals(this.getCounters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getAttackVectors() == null ? 0 : this.getAttackVectors().hashCode());
        hashCode = 31 * hashCode + (this.getCounters() == null ? 0 : this.getCounters().hashCode());
        return hashCode;
    }

    public SubResourceSummary clone() {
        try {
            return (SubResourceSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SubResourceSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

