/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemailv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.simpleemailv2.model.Contact;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class ContactMarshaller {
    private static final MarshallingInfo<String> EMAILADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EmailAddress").build();
    private static final MarshallingInfo<List> TOPICPREFERENCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TopicPreferences").build();
    private static final MarshallingInfo<List> TOPICDEFAULTPREFERENCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TopicDefaultPreferences").build();
    private static final MarshallingInfo<Boolean> UNSUBSCRIBEALL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UnsubscribeAll").build();
    private static final MarshallingInfo<Date> LASTUPDATEDTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdatedTimestamp").timestampFormat("unixTimestamp").build();
    private static final ContactMarshaller instance = new ContactMarshaller();

    public static ContactMarshaller getInstance() {
        return instance;
    }

    public void marshall(Contact contact, ProtocolMarshaller protocolMarshaller) {
        if (contact == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)contact.getEmailAddress(), EMAILADDRESS_BINDING);
            protocolMarshaller.marshall(contact.getTopicPreferences(), TOPICPREFERENCES_BINDING);
            protocolMarshaller.marshall(contact.getTopicDefaultPreferences(), TOPICDEFAULTPREFERENCES_BINDING);
            protocolMarshaller.marshall((Object)contact.getUnsubscribeAll(), UNSUBSCRIBEALL_BINDING);
            protocolMarshaller.marshall((Object)contact.getLastUpdatedTimestamp(), LASTUPDATEDTIMESTAMP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

