/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemailv2.model.transform;

import com.amazonaws.services.simpleemailv2.model.Message;
import com.amazonaws.services.simpleemailv2.model.transform.BodyJsonUnmarshaller;
import com.amazonaws.services.simpleemailv2.model.transform.ContentJsonUnmarshaller;
import com.amazonaws.services.simpleemailv2.model.transform.MessageHeaderJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class MessageJsonUnmarshaller
implements Unmarshaller<Message, JsonUnmarshallerContext> {
    private static MessageJsonUnmarshaller instance;

    public Message unmarshall(JsonUnmarshallerContext context) throws Exception {
        Message message = new Message();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Subject", targetDepth)) {
                    context.nextToken();
                    message.setSubject(ContentJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Body", targetDepth)) {
                    context.nextToken();
                    message.setBody(BodyJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Headers", targetDepth)) {
                    context.nextToken();
                    message.setHeaders(new ListUnmarshaller((Unmarshaller)MessageHeaderJsonUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return message;
    }

    public static MessageJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new MessageJsonUnmarshaller();
        }
        return instance;
    }
}

