/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemailv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.simpleemailv2.model.Topic;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateContactListRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String contactListName;
    private List<Topic> topics;
    private String description;

    public void setContactListName(String contactListName) {
        this.contactListName = contactListName;
    }

    public String getContactListName() {
        return this.contactListName;
    }

    public UpdateContactListRequest withContactListName(String contactListName) {
        this.setContactListName(contactListName);
        return this;
    }

    public List<Topic> getTopics() {
        return this.topics;
    }

    public void setTopics(Collection<Topic> topics) {
        if (topics == null) {
            this.topics = null;
            return;
        }
        this.topics = new ArrayList<Topic>(topics);
    }

    public UpdateContactListRequest withTopics(Topic ... topics) {
        if (this.topics == null) {
            this.setTopics(new ArrayList<Topic>(topics.length));
        }
        for (Topic ele : topics) {
            this.topics.add(ele);
        }
        return this;
    }

    public UpdateContactListRequest withTopics(Collection<Topic> topics) {
        this.setTopics(topics);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public UpdateContactListRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getContactListName() != null) {
            sb.append("ContactListName: ").append(this.getContactListName()).append(",");
        }
        if (this.getTopics() != null) {
            sb.append("Topics: ").append(this.getTopics()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateContactListRequest)) {
            return false;
        }
        UpdateContactListRequest other = (UpdateContactListRequest)obj;
        if (other.getContactListName() == null ^ this.getContactListName() == null) {
            return false;
        }
        if (other.getContactListName() != null && !other.getContactListName().equals(this.getContactListName())) {
            return false;
        }
        if (other.getTopics() == null ^ this.getTopics() == null) {
            return false;
        }
        if (other.getTopics() != null && !other.getTopics().equals(this.getTopics())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        return other.getDescription() == null || other.getDescription().equals(this.getDescription());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getContactListName() == null ? 0 : this.getContactListName().hashCode());
        hashCode = 31 * hashCode + (this.getTopics() == null ? 0 : this.getTopics().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        return hashCode;
    }

    public UpdateContactListRequest clone() {
        return (UpdateContactListRequest)super.clone();
    }
}

