/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicediscovery.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.servicediscovery.model.HealthStatusFilter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class DiscoverInstancesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String namespaceName;
    private String serviceName;
    private Integer maxResults;
    private Map<String, String> queryParameters;
    private Map<String, String> optionalParameters;
    private String healthStatus;

    public void setNamespaceName(String namespaceName) {
        this.namespaceName = namespaceName;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public DiscoverInstancesRequest withNamespaceName(String namespaceName) {
        this.setNamespaceName(namespaceName);
        return this;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public DiscoverInstancesRequest withServiceName(String serviceName) {
        this.setServiceName(serviceName);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public DiscoverInstancesRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public Map<String, String> getQueryParameters() {
        return this.queryParameters;
    }

    public void setQueryParameters(Map<String, String> queryParameters) {
        this.queryParameters = queryParameters;
    }

    public DiscoverInstancesRequest withQueryParameters(Map<String, String> queryParameters) {
        this.setQueryParameters(queryParameters);
        return this;
    }

    public DiscoverInstancesRequest addQueryParametersEntry(String key, String value) {
        if (null == this.queryParameters) {
            this.queryParameters = new HashMap<String, String>();
        }
        if (this.queryParameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.queryParameters.put(key, value);
        return this;
    }

    public DiscoverInstancesRequest clearQueryParametersEntries() {
        this.queryParameters = null;
        return this;
    }

    public Map<String, String> getOptionalParameters() {
        return this.optionalParameters;
    }

    public void setOptionalParameters(Map<String, String> optionalParameters) {
        this.optionalParameters = optionalParameters;
    }

    public DiscoverInstancesRequest withOptionalParameters(Map<String, String> optionalParameters) {
        this.setOptionalParameters(optionalParameters);
        return this;
    }

    public DiscoverInstancesRequest addOptionalParametersEntry(String key, String value) {
        if (null == this.optionalParameters) {
            this.optionalParameters = new HashMap<String, String>();
        }
        if (this.optionalParameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.optionalParameters.put(key, value);
        return this;
    }

    public DiscoverInstancesRequest clearOptionalParametersEntries() {
        this.optionalParameters = null;
        return this;
    }

    public void setHealthStatus(String healthStatus) {
        this.healthStatus = healthStatus;
    }

    public String getHealthStatus() {
        return this.healthStatus;
    }

    public DiscoverInstancesRequest withHealthStatus(String healthStatus) {
        this.setHealthStatus(healthStatus);
        return this;
    }

    public DiscoverInstancesRequest withHealthStatus(HealthStatusFilter healthStatus) {
        this.healthStatus = healthStatus.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNamespaceName() != null) {
            sb.append("NamespaceName: ").append(this.getNamespaceName()).append(",");
        }
        if (this.getServiceName() != null) {
            sb.append("ServiceName: ").append(this.getServiceName()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getQueryParameters() != null) {
            sb.append("QueryParameters: ").append(this.getQueryParameters()).append(",");
        }
        if (this.getOptionalParameters() != null) {
            sb.append("OptionalParameters: ").append(this.getOptionalParameters()).append(",");
        }
        if (this.getHealthStatus() != null) {
            sb.append("HealthStatus: ").append(this.getHealthStatus());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiscoverInstancesRequest)) {
            return false;
        }
        DiscoverInstancesRequest other = (DiscoverInstancesRequest)obj;
        if (other.getNamespaceName() == null ^ this.getNamespaceName() == null) {
            return false;
        }
        if (other.getNamespaceName() != null && !other.getNamespaceName().equals(this.getNamespaceName())) {
            return false;
        }
        if (other.getServiceName() == null ^ this.getServiceName() == null) {
            return false;
        }
        if (other.getServiceName() != null && !other.getServiceName().equals(this.getServiceName())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getQueryParameters() == null ^ this.getQueryParameters() == null) {
            return false;
        }
        if (other.getQueryParameters() != null && !other.getQueryParameters().equals(this.getQueryParameters())) {
            return false;
        }
        if (other.getOptionalParameters() == null ^ this.getOptionalParameters() == null) {
            return false;
        }
        if (other.getOptionalParameters() != null && !other.getOptionalParameters().equals(this.getOptionalParameters())) {
            return false;
        }
        if (other.getHealthStatus() == null ^ this.getHealthStatus() == null) {
            return false;
        }
        return other.getHealthStatus() == null || other.getHealthStatus().equals(this.getHealthStatus());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNamespaceName() == null ? 0 : this.getNamespaceName().hashCode());
        hashCode = 31 * hashCode + (this.getServiceName() == null ? 0 : this.getServiceName().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getQueryParameters() == null ? 0 : this.getQueryParameters().hashCode());
        hashCode = 31 * hashCode + (this.getOptionalParameters() == null ? 0 : this.getOptionalParameters().hashCode());
        hashCode = 31 * hashCode + (this.getHealthStatus() == null ? 0 : this.getHealthStatus().hashCode());
        return hashCode;
    }

    public DiscoverInstancesRequest clone() {
        return (DiscoverInstancesRequest)super.clone();
    }
}

