/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicediscovery.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.servicediscovery.model.NamespaceSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListNamespacesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<NamespaceSummary> namespaces;
    private String nextToken;

    public List<NamespaceSummary> getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(Collection<NamespaceSummary> namespaces) {
        if (namespaces == null) {
            this.namespaces = null;
            return;
        }
        this.namespaces = new ArrayList<NamespaceSummary>(namespaces);
    }

    public ListNamespacesResult withNamespaces(NamespaceSummary ... namespaces) {
        if (this.namespaces == null) {
            this.setNamespaces(new ArrayList<NamespaceSummary>(namespaces.length));
        }
        for (NamespaceSummary ele : namespaces) {
            this.namespaces.add(ele);
        }
        return this;
    }

    public ListNamespacesResult withNamespaces(Collection<NamespaceSummary> namespaces) {
        this.setNamespaces(namespaces);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListNamespacesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNamespaces() != null) {
            sb.append("Namespaces: ").append(this.getNamespaces()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNamespacesResult)) {
            return false;
        }
        ListNamespacesResult other = (ListNamespacesResult)obj;
        if (other.getNamespaces() == null ^ this.getNamespaces() == null) {
            return false;
        }
        if (other.getNamespaces() != null && !other.getNamespaces().equals(this.getNamespaces())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNamespaces() == null ? 0 : this.getNamespaces().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListNamespacesResult clone() {
        try {
            return (ListNamespacesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

