/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicecatalog.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.servicecatalog.model.transform.ExecutionParameterMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ExecutionParameter
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String type;
    private List<String> defaultValues;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ExecutionParameter withName(String name) {
        this.setName(name);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public ExecutionParameter withType(String type) {
        this.setType(type);
        return this;
    }

    public List<String> getDefaultValues() {
        return this.defaultValues;
    }

    public void setDefaultValues(Collection<String> defaultValues) {
        if (defaultValues == null) {
            this.defaultValues = null;
            return;
        }
        this.defaultValues = new ArrayList<String>(defaultValues);
    }

    public ExecutionParameter withDefaultValues(String ... defaultValues) {
        if (this.defaultValues == null) {
            this.setDefaultValues(new ArrayList<String>(defaultValues.length));
        }
        for (String ele : defaultValues) {
            this.defaultValues.add(ele);
        }
        return this;
    }

    public ExecutionParameter withDefaultValues(Collection<String> defaultValues) {
        this.setDefaultValues(defaultValues);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getDefaultValues() != null) {
            sb.append("DefaultValues: ").append(this.getDefaultValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionParameter)) {
            return false;
        }
        ExecutionParameter other = (ExecutionParameter)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getDefaultValues() == null ^ this.getDefaultValues() == null) {
            return false;
        }
        return other.getDefaultValues() == null || other.getDefaultValues().equals(this.getDefaultValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultValues() == null ? 0 : this.getDefaultValues().hashCode());
        return hashCode;
    }

    public ExecutionParameter clone() {
        try {
            return (ExecutionParameter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExecutionParameterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

