/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicecatalog.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.servicecatalog.model.ResourceDetail;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListResourcesForTagOptionResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<ResourceDetail> resourceDetails;
    private String pageToken;

    public List<ResourceDetail> getResourceDetails() {
        return this.resourceDetails;
    }

    public void setResourceDetails(Collection<ResourceDetail> resourceDetails) {
        if (resourceDetails == null) {
            this.resourceDetails = null;
            return;
        }
        this.resourceDetails = new ArrayList<ResourceDetail>(resourceDetails);
    }

    public ListResourcesForTagOptionResult withResourceDetails(ResourceDetail ... resourceDetails) {
        if (this.resourceDetails == null) {
            this.setResourceDetails(new ArrayList<ResourceDetail>(resourceDetails.length));
        }
        for (ResourceDetail ele : resourceDetails) {
            this.resourceDetails.add(ele);
        }
        return this;
    }

    public ListResourcesForTagOptionResult withResourceDetails(Collection<ResourceDetail> resourceDetails) {
        this.setResourceDetails(resourceDetails);
        return this;
    }

    public void setPageToken(String pageToken) {
        this.pageToken = pageToken;
    }

    public String getPageToken() {
        return this.pageToken;
    }

    public ListResourcesForTagOptionResult withPageToken(String pageToken) {
        this.setPageToken(pageToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceDetails() != null) {
            sb.append("ResourceDetails: ").append(this.getResourceDetails()).append(",");
        }
        if (this.getPageToken() != null) {
            sb.append("PageToken: ").append(this.getPageToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourcesForTagOptionResult)) {
            return false;
        }
        ListResourcesForTagOptionResult other = (ListResourcesForTagOptionResult)obj;
        if (other.getResourceDetails() == null ^ this.getResourceDetails() == null) {
            return false;
        }
        if (other.getResourceDetails() != null && !other.getResourceDetails().equals(this.getResourceDetails())) {
            return false;
        }
        if (other.getPageToken() == null ^ this.getPageToken() == null) {
            return false;
        }
        return other.getPageToken() == null || other.getPageToken().equals(this.getPageToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceDetails() == null ? 0 : this.getResourceDetails().hashCode());
        hashCode = 31 * hashCode + (this.getPageToken() == null ? 0 : this.getPageToken().hashCode());
        return hashCode;
    }

    public ListResourcesForTagOptionResult clone() {
        try {
            return (ListResourcesForTagOptionResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

