/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicecatalog.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.servicecatalog.model.RecordDetail;
import com.amazonaws.services.servicecatalog.model.RecordError;
import com.amazonaws.services.servicecatalog.model.RecordTag;
import com.amazonaws.services.servicecatalog.model.transform.RecordErrorJsonMarshaller;
import com.amazonaws.services.servicecatalog.model.transform.RecordTagJsonMarshaller;
import java.util.List;

public class RecordDetailJsonMarshaller {
    private static RecordDetailJsonMarshaller instance;

    public void marshall(RecordDetail recordDetail, StructuredJsonGenerator jsonGenerator) {
        if (recordDetail == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<RecordTag> recordTagsList;
            List<RecordError> recordErrorsList;
            jsonGenerator.writeStartObject();
            if (recordDetail.getRecordId() != null) {
                jsonGenerator.writeFieldName("RecordId").writeValue(recordDetail.getRecordId());
            }
            if (recordDetail.getProvisionedProductName() != null) {
                jsonGenerator.writeFieldName("ProvisionedProductName").writeValue(recordDetail.getProvisionedProductName());
            }
            if (recordDetail.getStatus() != null) {
                jsonGenerator.writeFieldName("Status").writeValue(recordDetail.getStatus());
            }
            if (recordDetail.getCreatedTime() != null) {
                jsonGenerator.writeFieldName("CreatedTime").writeValue(recordDetail.getCreatedTime());
            }
            if (recordDetail.getUpdatedTime() != null) {
                jsonGenerator.writeFieldName("UpdatedTime").writeValue(recordDetail.getUpdatedTime());
            }
            if (recordDetail.getProvisionedProductType() != null) {
                jsonGenerator.writeFieldName("ProvisionedProductType").writeValue(recordDetail.getProvisionedProductType());
            }
            if (recordDetail.getRecordType() != null) {
                jsonGenerator.writeFieldName("RecordType").writeValue(recordDetail.getRecordType());
            }
            if (recordDetail.getProvisionedProductId() != null) {
                jsonGenerator.writeFieldName("ProvisionedProductId").writeValue(recordDetail.getProvisionedProductId());
            }
            if (recordDetail.getProductId() != null) {
                jsonGenerator.writeFieldName("ProductId").writeValue(recordDetail.getProductId());
            }
            if (recordDetail.getProvisioningArtifactId() != null) {
                jsonGenerator.writeFieldName("ProvisioningArtifactId").writeValue(recordDetail.getProvisioningArtifactId());
            }
            if (recordDetail.getPathId() != null) {
                jsonGenerator.writeFieldName("PathId").writeValue(recordDetail.getPathId());
            }
            if ((recordErrorsList = recordDetail.getRecordErrors()) != null) {
                jsonGenerator.writeFieldName("RecordErrors");
                jsonGenerator.writeStartArray();
                for (RecordError recordErrorsListValue : recordErrorsList) {
                    if (recordErrorsListValue == null) continue;
                    RecordErrorJsonMarshaller.getInstance().marshall(recordErrorsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((recordTagsList = recordDetail.getRecordTags()) != null) {
                jsonGenerator.writeFieldName("RecordTags");
                jsonGenerator.writeStartArray();
                for (RecordTag recordTagsListValue : recordTagsList) {
                    if (recordTagsListValue == null) continue;
                    RecordTagJsonMarshaller.getInstance().marshall(recordTagsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RecordDetailJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RecordDetailJsonMarshaller();
        }
        return instance;
    }
}

