/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicecatalog.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.servicecatalog.model.ParameterConstraints;
import java.util.List;

public class ParameterConstraintsJsonMarshaller {
    private static ParameterConstraintsJsonMarshaller instance;

    public void marshall(ParameterConstraints parameterConstraints, StructuredJsonGenerator jsonGenerator) {
        if (parameterConstraints == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            List<String> allowedValuesList = parameterConstraints.getAllowedValues();
            if (allowedValuesList != null) {
                jsonGenerator.writeFieldName("AllowedValues");
                jsonGenerator.writeStartArray();
                for (String allowedValuesListValue : allowedValuesList) {
                    if (allowedValuesListValue == null) continue;
                    jsonGenerator.writeValue(allowedValuesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ParameterConstraintsJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ParameterConstraintsJsonMarshaller();
        }
        return instance;
    }
}

